
package net.lightapi.portal.oauth.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get one refresh token detail.
*/
@ServiceHandler(id="lightapi.net/oauth/getRefreshTokenDetail/0.1.0")
public class GetRefreshTokenDetail implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRefreshTokenDetail.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String refreshToken = (String)map.get("refreshToken");

        if(logger.isTraceEnabled()) logger.trace("refreshToken = {}", refreshToken);

        Result<String> result = dbProvider.queryRefreshToken(refreshToken);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "refresh token", refreshToken));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
