
package net.lightapi.portal.oauth.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get all currently active refresh tokens.
 */
@ServiceHandler(id="lightapi.net/oauth/getRefreshToken/0.1.0")
public class GetRefreshToken implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRefreshToken.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String refreshToken = (String)map.get("refreshToken");
        if(StringUtils.isBlank(refreshToken)) refreshToken = null;
        String userId = (String)map.get("userId");
        if(StringUtils.isBlank(userId)) userId = null;
        String entityId = (String)map.get("entityId");
        if(StringUtils.isBlank(entityId)) entityId = null;
        String email = (String)map.get("email");
        if(StringUtils.isBlank(email)) email = null;
        String firstName = (String)map.get("firstName");
        if(StringUtils.isBlank(firstName)) firstName = null;
        String lastName = (String)map.get("lastName");
        if(StringUtils.isBlank(lastName)) lastName = null;
        String clientId = (String)map.get("clientId");
        if(StringUtils.isBlank(clientId)) clientId = null;
        String appId = (String)map.get("appId");
        if(StringUtils.isBlank(appId)) appId = null;
        String appName = (String)map.get("appName");
        if(StringUtils.isBlank(appName)) appName = null;
        String scope = (String)map.get("scope");
        if(StringUtils.isBlank(scope)) scope = null;
        String userType = (String)map.get("userType");
        if(StringUtils.isBlank(userType)) userType = null;
        String roles = (String)map.get("roles");
        if(StringUtils.isBlank(roles)) roles = null;
        String groups = (String)map.get("groups");
        if(StringUtils.isBlank(groups)) groups = null;
        String positions = (String)map.get("positions");
        if(StringUtils.isBlank(positions)) positions = null;
        String attributes = (String)map.get("attributes");
        if(StringUtils.isBlank(attributes)) attributes = null;
        String csrf = (String)map.get("csrf");
        if(StringUtils.isBlank(csrf)) csrf = null;
        String customClaim = (String)map.get("customClaim");
        if(StringUtils.isBlank(customClaim)) customClaim = null;
        String updateUser = (String)map.get("updateUser");
        if(StringUtils.isBlank(updateUser)) updateUser = null;
        Timestamp updateTs = null;
        String s = (String)map.get("updateTs");
        if(!StringUtils.isBlank(s)) {
            updateTs = Timestamp.valueOf(s);
        }

        Result<String> result = dbProvider.listRefreshToken(offset, limit, refreshToken, hostId, userId, entityId,
                email, firstName, lastName, clientId, appId, appName, scope, userType, roles, groups, positions,
                attributes, csrf, customClaim, updateUser, updateTs);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "refresh token", hostId));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
