
package net.lightapi.portal.oauth.query.handler;

import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get reference token detail
*/
@ServiceHandler(id="lightapi.net/oauth/getRefTokenDetail/0.1.0")
public class GetRefTokenDetail implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRefTokenDetail.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    private static final String PERMISSION_DENIED = "ERR11620";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        Map<String, Object> map = (Map<String, Object>)input;
        String refToken = (String)map.get("refToken");
        return NioUtils.toByteBuffer("");
        /*
        ReadOnlyKeyValueStore<String, String> keyValueStore = MarketQueryStartup.streams.getRefStore();
        String data = (String) MarketQueryStartup.streams.getKafkaValueByKey(keyValueStore, refToken);
        if(data != null) {
            return NioUtils.toByteBuffer(data);
        } else {
            KeyQueryMetadata metadata = MarketQueryStartup.streams.getRefStreamsMetadata(refToken);
            HostInfo hostInfo = metadata.activeHost();
            if(logger.isDebugEnabled()) logger.debug("found address in another instance " + hostInfo.host() + ":" + hostInfo.port());
            String url = "https://" + hostInfo.host() + ":" + hostInfo.port();
            if(NetUtils.getLocalAddressByDatagram().equals(hostInfo.host()) && ServerConfig.getInstance().getHttpsPort() == hostInfo.port()) {
                // TODO remove this block if we never seen the following error.
                logger.error("******Kafka returns the same instance!");
                return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "refToken", refToken));
            } else {
                Result<String> resultStatus = HybridQueryClient.getRefTokenDetail(exchange, url, refToken);
                if (resultStatus.isSuccess()) {
                    return NioUtils.toByteBuffer(resultStatus.getResult());
                }
            }
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "ref token", refToken));
        }
        */
    }
}
