
package net.lightapi.portal.oauth.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get list of reference tokens
*/
@ServiceHandler(id="lightapi.net/oauth/getRefToken/0.1.0")
public class GetRefToken implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRefToken.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        Map<String, Object> map = (Map<String, Object>)input;
        String host = (String)map.get("host");
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        return NioUtils.toByteBuffer("");
        /*
        ReadOnlyKeyValueStore<String, String> keyValueStore = MarketQueryStartup.streams.getHostStore();
        String data = (String) MarketQueryStartup.streams.getKafkaValueByKey(keyValueStore, host);
        if(data != null) {
            List<Object> list = new ArrayList<>();
            int total = 0;
            if(data != null) {
                if(logger.isTraceEnabled()) logger.trace("data = " + data);
                Map<String, Object> hostMap = JsonMapper.string2Map(data);
                List refs = (List)hostMap.get("ref");
                if(refs != null && refs.size() >= offset) {
                    int max = refs.size() > offset + limit ? offset + limit : refs.size();
                    total = refs.size();
                    for(int i = offset; i < max; i++) {
                        list.add(refs.get(i));
                    }
                }
            }
            Map<String, Object> result = new HashMap<>();
            result.put("refs", list);
            result.put("total", total);
            return NioUtils.toByteBuffer(JsonMapper.toJson(result));
        } else {
            KeyQueryMetadata metadata = MarketQueryStartup.streams.getHostStreamsMetadata(host);
            HostInfo hostInfo = metadata.activeHost();
            if(logger.isDebugEnabled()) logger.debug("found address in another instance " + hostInfo.host() + ":" + hostInfo.port());
            String url = "https://" + hostInfo.host() + ":" + hostInfo.port();
            if(NetUtils.getLocalAddressByDatagram().equals(hostInfo.host()) && ServerConfig.getInstance().getHttpsPort() == hostInfo.port()) {
                // TODO remove this block if we never seen the following error.
                logger.error("******Kafka returns the same instance!");
                return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "host", host));
            } else {
                Result<String> resultStatus = HybridQueryClient.getRefToken(exchange, url, host, offset, limit);
                if (resultStatus.isSuccess()) {
                    return NioUtils.toByteBuffer(resultStatus.getResult());
                }
            }
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "host", host));
        }
        */
    }
}
