
package net.lightapi.portal.oauth.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get providers by hostId
*/
@ServiceHandler(id="lightapi.net/oauth/getProvider/0.1.0")
public class GetProvider implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetProvider.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String providerId = (String)map.get("providerId");
        if(StringUtils.isBlank(providerId)) providerId = null;
        String providerName = (String)map.get("providerName");
        if(StringUtils.isBlank(providerName)) providerName = null;
        String providerDesc = (String)map.get("providerDesc");
        if(StringUtils.isBlank(providerDesc)) providerDesc = null;
        String operationOwner = (String)map.get("operationOwner");
        if(StringUtils.isBlank(operationOwner)) operationOwner = null;
        String deliveryOwner = (String)map.get("deliveryOwner");
        if(StringUtils.isBlank(deliveryOwner)) deliveryOwner = null;
        String jwk = (String)map.get("jwk");
        if(StringUtils.isBlank(jwk)) jwk = null;
        String updateUser = (String)map.get("updateUser");
        if(StringUtils.isBlank(updateUser)) updateUser = null;

        Timestamp updateTs = null;
        String s = (String)map.get("updateTs");
        if(!StringUtils.isBlank(s)) {
            updateTs = Timestamp.valueOf(s);
        }

        Result<String> result = dbProvider.queryProvider(offset, limit, hostId, providerId, providerName,
                providerDesc, operationOwner, deliveryOwner, jwk, updateUser, updateTs);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "provider", hostId));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
