
package net.lightapi.portal.oauth.query.handler;

import com.networknt.monad.Result;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static net.lightapi.portal.oauth.query.handler.GetRefreshTokenDetail.dbProvider;

/**
 * get client by provider id client id by the oauth-kafka services
*/
@ServiceHandler(id="lightapi.net/oauth/getClientByProviderClientId/0.1.0")
public class GetClientByProviderClientId implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetAuthCodeDetail.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String providerId = (String)map.get("providerId");
        String clientId = (String)map.get("clientId");
        Result<String> result = dbProvider.queryClientByProviderClientId(providerId, clientId);
        if(result.isSuccess()) {
            return NioUtils.toByteBuffer(result.getResult());
        } else {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "client", "providerId = " + providerId + " clientId = " + clientId));
        }
    }
}
