
package net.lightapi.portal.oauth.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get all client ids belong to one host from a global host key value store. By clicking
 * each clientId on the UI, one can see the details of the registered client.
 *
 * @author Steve Hu
 */
@ServiceHandler(id="lightapi.net/oauth/getClient/0.1.0")
public class GetClient implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetClient.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String appId = (String)map.get("appId");
        if(StringUtils.isBlank(appId)) appId = null;
        String apiId = (String)map.get("apiId");
        if(StringUtils.isBlank(apiId)) apiId = null;

        String clientId = (String)map.get("clientId");
        if(StringUtils.isBlank(clientId)) clientId = null;
        String clientName = (String)map.get("clientName");
        if(StringUtils.isBlank(clientName)) clientName = null;
        String clientType = (String)map.get("clientType");
        if(StringUtils.isBlank(clientType)) clientType = null;
        String clientProfile = (String)map.get("clientProfile");
        if(StringUtils.isBlank(clientProfile)) clientProfile = null;
        String clientScope = (String)map.get("clientScope");
        if(StringUtils.isBlank(clientScope)) clientScope = null;
        String customClaim = (String)map.get("customClaim");
        if(StringUtils.isBlank(customClaim)) customClaim = null;
        String redirectUri = (String)map.get("redirectUri");
        if(StringUtils.isBlank(redirectUri)) redirectUri = null;
        String authenticateClass = (String)map.get("authenticateClass");
        if(StringUtils.isBlank(authenticateClass)) authenticateClass = null;
        String deRefClientId = (String)map.get("deRefClientId");
        if(StringUtils.isBlank(deRefClientId)) deRefClientId = null;


        if(logger.isTraceEnabled())
            logger.trace("offset = {} limit = {} hostId = {} appId = {} apiId = {} clientId = {} clientName = {} clientType = {} clientProfile = {} clientScope = {} customClaim = {} redirectUri = {} authenticateClass = {} deRefClientId = {}", offset, limit, hostId, appId, apiId, clientId, clientName, clientType, clientProfile, clientScope, customClaim, redirectUri, authenticateClass, deRefClientId);
        Result<String> result = dbProvider.queryClient(offset, limit, hostId, appId, apiId, clientId, clientName, clientType, clientProfile, clientScope, customClaim, redirectUri, authenticateClass, deRefClientId);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "client", "hostId:" + hostId + " appId:" + appId));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }

    }
}
