
package net.lightapi.portal.oauth.query.handler;

import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static net.lightapi.portal.oauth.query.handler.GetRefreshTokenDetail.dbProvider;

/**
 * Get an authorization code details by the hostId and authorization code.
 */
@ServiceHandler(id="lightapi.net/oauth/getAuthCodeDetail/0.1.0")
public class GetAuthCodeDetail implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetAuthCodeDetail.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String authCode = (String)map.get("authCode");
        Result<String> result = dbProvider.queryAuthCode(authCode);
        if(result.isSuccess()) {
            return NioUtils.toByteBuffer(result.getResult());
        } else {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "auth code", authCode));
        }
    }
}
