
package net.lightapi.portal.oauth.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import com.networknt.utility.StringUtils;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get a list of authorization codes that are currently active for the hostId.
*/
@ServiceHandler(id="lightapi.net/oauth/getAuthCode/0.1.0")
public class GetAuthCode implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetAuthCode.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String authCode = (String)map.get("authCode");
        if(StringUtils.isBlank(authCode)) authCode = null;
        String userId = (String)map.get("userId");
        if(StringUtils.isBlank(userId)) userId = null;
        String entityId = (String)map.get("entityId");
        if(StringUtils.isBlank(entityId)) entityId = null;
        String userType = (String)map.get("userType");
        if(StringUtils.isBlank(userType)) userType = null;
        String email = (String)map.get("email");
        if(StringUtils.isBlank(email)) email = null;
        String roles = (String)map.get("roles");
        if(StringUtils.isBlank(roles)) roles = null;
        String groups = (String)map.get("groups");
        if(StringUtils.isBlank(groups)) groups = null;
        String positions = (String)map.get("positions");
        if(StringUtils.isBlank(positions)) positions = null;
        String attributes = (String)map.get("attributes");
        if(StringUtils.isBlank(attributes)) attributes = null;
        String redirectUri = (String)map.get("redirectUri");
        if(StringUtils.isBlank(redirectUri)) redirectUri = null;
        String scope = (String)map.get("scope");
        if(StringUtils.isBlank(scope)) scope = null;
        String remember = (String)map.get("remember");
        if(StringUtils.isBlank(remember)) remember = null;
        String codeChallenge = (String)map.get("codeChallenge");
        if(StringUtils.isBlank(codeChallenge)) codeChallenge = null;
        String challengeMethod = (String)map.get("challengeMethod");
        if(StringUtils.isBlank(challengeMethod)) challengeMethod = null;
        String updateUser = (String)map.get("updateUser");
        if(StringUtils.isBlank(updateUser)) updateUser = null;
        if(StringUtils.isBlank(updateUser)) updateUser = null;
        Timestamp updateTs = null;
        String s = (String)map.get("updateTs");
        if(!StringUtils.isBlank(s)) {
            updateTs = Timestamp.valueOf(s);
        }

        Result<String> result = dbProvider.listAuthCode(offset, limit, authCode, hostId, userId, entityId, userType,
                email, roles, groups, positions, attributes, redirectUri, scope, remember, codeChallenge,
                challengeMethod, updateUser, updateTs);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "auth code", hostId));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
