
package net.lightapi.portal.oauth.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Update an OAuth 2.0 provider in a cluster and it is called from the light-view by admin. A authorization code token is
 * needed to access this endpoint. The host and providerId are readonly and cannot be updated.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/oauth/updateProvider/0.1.0")
public class UpdateProvider extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateProvider.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.AUTH_PROVIDER_UPDATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_PROVIDER;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the providerId in the data section. It is generated by enrichInput method.
        return (String) map.get("providerId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
