
package net.lightapi.portal.oauth.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * This endpoint will be called by light-oauth2 and portal UI to remove compromised refresh token by admin.
 *
 * client credentials token will be used if called from the light-oauth2
 * authorization code token will be used if called from the Portal UI.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/oauth/deleteRefreshToken/0.1.0")
public class DeleteRefreshToken extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteRefreshToken.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.AUTH_REFRESH_TOKEN_DELETED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_REFRESH_TOKEN;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the refreshToken in the data section.
        return (String) map.get("refreshToken");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
