
package net.lightapi.portal.oauth.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;

import java.util.Map;

/**
 * This endpoint will be called by oauth-kafka and portal UI to remove compromised authorization code by admin.
 * In both cases, an authorization code token will be used to perform the action. From the oauth-kafka, this is
 * called after the jwt token is created, and we just need to pass that token to this endpoint. From the portal
 * UI, the user must be an admin to call this endpoint and the jwt token is passed in the header.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/oauth/deleteAuthCode/0.1.0")
public class DeleteAuthCode extends AbstractCommandHandler {

    @Override
    protected String getCloudEventType() {
        return PortalConstants.AUTH_CODE_DELETED_EVENT;
    }
    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_AUTH_CODE;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the authCode in the data section.
        return (String) map.get("authCode");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
