
package net.lightapi.portal.oauth.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Create a refresh token from the light-oauth2 token service. The refresh token will be used for user
 * based grant flow, and it must be associated with a token that has a uid. Use that token to create
 * refresh token or delete refresh token. For service to service invocation, a client credentials token
 * will be created and cached for each request and there is no refresh token involves.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/oauth/createRefreshToken/0.1.0")
public class CreateRefreshToken extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateRefreshToken.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.AUTH_REFRESH_TOKEN_CREATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_REFRESH_TOKEN;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the refreshToken in the data section.
        return (String) map.get("refreshToken");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
