
package net.lightapi.portal.oauth.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Create a reference token for external client so that the light-router can convert it into a JWT token for internal use.
 * This endpoint is called from the oauth-kafka service. A client credentials token is needed to access this endpoint.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/oauth/createRefToken/0.1.0")
public class CreateRefToken extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateRefToken.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.AUTH_REF_TOKEN_CREATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_REF_TOKEN;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the refToken in the data section.
        return (String) map.get("refToken");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
