/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.oauth.command.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.security.KeyUtil;
import com.networknt.status.Status;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/oauth/rotateProvider/0.1.0")
public class RotateProvider
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(RotateProvider.class);
    private static final String PROVIDER_KEY_TYPE_MISSING = "ERR11639";
    private static final String PROVIDER_KEY_TYPE_INVALID = "ERR11640";
    private static final String KEY_GENERATION_ERROR = "ERR12054";

    protected String getCloudEventType() {
        return "AuthProviderRotatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String rotateKeyType = (String)map.get("keyType");
        String providerId = (String)map.get("providerId");
        String hostId = (String)map.get("hostId");
        if (rotateKeyType == null || rotateKeyType.isBlank()) {
            return Failure.of((Status)new Status(PROVIDER_KEY_TYPE_MISSING, new Object[0]));
        }
        if (!rotateKeyType.equals("LC") && !rotateKeyType.equals("TC")) {
            return Failure.of((Status)new Status(PROVIDER_KEY_TYPE_INVALID, new Object[]{rotateKeyType}));
        }
        String removeKeyType = rotateKeyType.equals("LC") ? "LP" : "TP";
        Result providerKeyResult = HybridQueryClient.getProviderKey((HttpServerExchange)exchange, (String)hostId, (String)providerId);
        if (providerKeyResult.isFailure()) {
            return Failure.of((Status)providerKeyResult.getError());
        }
        HashMap<String, String> insertMap = new HashMap<String, String>();
        List keys = JsonMapper.string2List((String)((String)providerKeyResult.getResult()));
        try {
            KeyPair keyPair = KeyUtil.generateKeyPair((String)"RSA", (int)2048);
            String kid = UuidUtil.uuidToBase64((UUID)UuidUtil.getUUID());
            PublicJsonWebKey jwk = PublicJsonWebKey.Factory.newPublicJwk((Key)keyPair.getPublic());
            jwk.setKeyId(kid);
            String publicKey = KeyUtil.serializePublicKey((PublicKey)keyPair.getPublic());
            String privateKey = KeyUtil.serializePrivateKey((PrivateKey)keyPair.getPrivate());
            insertMap.put("publicKey", publicKey);
            insertMap.put("privateKey", privateKey);
            insertMap.put("kid", kid);
            insertMap.put("keyType", rotateKeyType);
            map.put("insert", insertMap);
            ArrayList<PublicJsonWebKey> jwkList = new ArrayList<PublicJsonWebKey>();
            jwkList.add(jwk);
            for (Map key : keys) {
                if (key.get("keyType").equals(rotateKeyType)) {
                    HashMap updateMap = new HashMap();
                    updateMap.put("kid", key.get("kid"));
                    updateMap.put("keyType", removeKeyType);
                    map.put("update", updateMap);
                    jwk = PublicJsonWebKey.Factory.newPublicJwk((Key)KeyUtil.deserializePublicKey((String)((String)key.get("publicKey")), (String)"RSA"));
                    jwk.setKeyId((String)key.get("kid"));
                    jwkList.add(jwk);
                    continue;
                }
                if (key.get("keyType").equals(removeKeyType)) {
                    HashMap deleteMap = new HashMap();
                    deleteMap.put("kid", key.get("kid"));
                    map.put("delete", deleteMap);
                    jwk = PublicJsonWebKey.Factory.newPublicJwk((Key)KeyUtil.deserializePublicKey((String)((String)key.get("publicKey")), (String)"RSA"));
                    jwk.setKeyId((String)key.get("kid"));
                    jwkList.add(jwk);
                    continue;
                }
                jwk = PublicJsonWebKey.Factory.newPublicJwk((Key)KeyUtil.deserializePublicKey((String)((String)key.get("publicKey")), (String)"RSA"));
                jwk.setKeyId((String)key.get("kid"));
                jwkList.add(jwk);
            }
            JsonWebKeySet jwks = new JsonWebKeySet(jwkList);
            String jwkJson = jwks.toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY);
            map.put("jwk", jwkJson);
        }
        catch (Exception e) {
            return Failure.of((Status)new Status(KEY_GENERATION_ERROR, new Object[]{e.getMessage()}));
        }
        return Success.of(map);
    }
}

