/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.oauth.command.handler;

import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.security.KeyUtil;
import com.networknt.status.Status;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/oauth/createProvider/0.1.0")
public class CreateProvider
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateProvider.class);
    private static final String KEY_GENERATION_ERROR = "ERR12054";

    protected String getCloudEventType() {
        return "AuthProviderCreatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String providerId = (String)map.get("providerId");
        if (providerId == null) {
            providerId = UuidUtil.uuidToBase64((UUID)UuidUtil.getUUID());
            map.put("providerId", providerId);
        }
        HashMap keys = new HashMap();
        try {
            ArrayList<PublicJsonWebKey> jwkList = new ArrayList<PublicJsonWebKey>();
            KeyPair longKeyPairCurr = KeyUtil.generateKeyPair((String)"RSA", (int)2048);
            String longKeyIdCurr = UuidUtil.uuidToBase64((UUID)UuidUtil.getUUID());
            PublicJsonWebKey jwk = PublicJsonWebKey.Factory.newPublicJwk((Key)longKeyPairCurr.getPublic());
            jwk.setKeyId(longKeyIdCurr);
            jwkList.add(jwk);
            String longPublicKeyCurr = KeyUtil.serializePublicKey((PublicKey)longKeyPairCurr.getPublic());
            String longPrivateKeyCurr = KeyUtil.serializePrivateKey((PrivateKey)longKeyPairCurr.getPrivate());
            HashMap<String, String> lcMap = new HashMap<String, String>();
            lcMap.put("publicKey", longPublicKeyCurr);
            lcMap.put("privateKey", longPrivateKeyCurr);
            lcMap.put("kid", longKeyIdCurr);
            keys.put("LC", lcMap);
            KeyPair longKeyPairPrev = KeyUtil.generateKeyPair((String)"RSA", (int)2048);
            String longKeyIdPrev = UuidUtil.uuidToBase64((UUID)UuidUtil.getUUID());
            jwk = PublicJsonWebKey.Factory.newPublicJwk((Key)longKeyPairPrev.getPublic());
            jwk.setKeyId(longKeyIdPrev);
            jwkList.add(jwk);
            String longPublicKeyPrev = KeyUtil.serializePublicKey((PublicKey)longKeyPairPrev.getPublic());
            String longPrivateKeyPrev = KeyUtil.serializePrivateKey((PrivateKey)longKeyPairPrev.getPrivate());
            HashMap<String, String> lpMap = new HashMap<String, String>();
            lpMap.put("publicKey", longPublicKeyPrev);
            lpMap.put("privateKey", longPrivateKeyPrev);
            lpMap.put("kid", longKeyIdPrev);
            keys.put("LP", lpMap);
            KeyPair tokenKeyPairCurr = KeyUtil.generateKeyPair((String)"RSA", (int)2048);
            String tokenKeyIdCurr = UuidUtil.uuidToBase64((UUID)UuidUtil.getUUID());
            jwk = PublicJsonWebKey.Factory.newPublicJwk((Key)tokenKeyPairCurr.getPublic());
            jwk.setKeyId(tokenKeyIdCurr);
            jwkList.add(jwk);
            String tokenPublicKeyCurr = KeyUtil.serializePublicKey((PublicKey)tokenKeyPairCurr.getPublic());
            String tokenPrivateKeyCurr = KeyUtil.serializePrivateKey((PrivateKey)tokenKeyPairCurr.getPrivate());
            HashMap<String, String> tcMap = new HashMap<String, String>();
            tcMap.put("publicKey", tokenPublicKeyCurr);
            tcMap.put("privateKey", tokenPrivateKeyCurr);
            tcMap.put("kid", tokenKeyIdCurr);
            keys.put("TC", tcMap);
            KeyPair tokenKeyPairPrev = KeyUtil.generateKeyPair((String)"RSA", (int)2048);
            String tokenKeyIdPrev = UuidUtil.uuidToBase64((UUID)UuidUtil.getUUID());
            jwk = PublicJsonWebKey.Factory.newPublicJwk((Key)tokenKeyPairPrev.getPublic());
            jwk.setKeyId(tokenKeyIdPrev);
            jwkList.add(jwk);
            String tokenPublicKeyPrev = KeyUtil.serializePublicKey((PublicKey)tokenKeyPairPrev.getPublic());
            String tokenPrivateKeyPrev = KeyUtil.serializePrivateKey((PrivateKey)tokenKeyPairPrev.getPrivate());
            HashMap<String, String> tpMap = new HashMap<String, String>();
            tpMap.put("publicKey", tokenPublicKeyPrev);
            tpMap.put("privateKey", tokenPrivateKeyPrev);
            tpMap.put("kid", tokenKeyIdPrev);
            keys.put("TP", tpMap);
            JsonWebKeySet jwks = new JsonWebKeySet(jwkList);
            String jwkJson = jwks.toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY);
            map.put("jwk", jwkJson);
        }
        catch (Exception e) {
            return Failure.of((Status)new Status(KEY_GENERATION_ERROR, new Object[]{e.getMessage()}));
        }
        map.put("keys", keys);
        return Success.of(map);
    }
}

