/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.oauth.command.handler;

import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import com.networknt.utility.HashUtil;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.UUID;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/oauth/createClient/0.1.0")
public class CreateClient
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateClient.class);
    private static final String ERROR_HASHING_PASSWORD = "ERR11614";

    protected String getCloudEventType() {
        return "ClientCreatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String clientId = UuidUtil.getUUID().toString();
        String clientSecret = UuidUtil.uuidToBase64((UUID)UuidUtil.getUUID());
        String clientSecretEncrypted = null;
        try {
            clientSecretEncrypted = HashUtil.generateStrongPasswordHash((String)clientSecret);
            map.put("clientSecret", clientSecretEncrypted);
            map.put("clientId", clientId);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            logger.error("Exception:", (Throwable)e);
            return Failure.of((Status)new Status(ERROR_HASHING_PASSWORD, new Object[]{e.getMessage()}));
        }
        return Success.of(map);
    }
}

