
package net.lightapi.portal.oauth.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This endpoint will be called by oauth-kafka and portal UI to remove reference token used by the external clients.
 *
 * client credentials token will be used if called from the oauth-kafka
 * reference token will be used if called from the Portal UI to delete the entry
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/oauth/deleteRefToken/0.1.0")
public class DeleteRefToken extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteRefToken.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.AUTH_REF_TOKEN_DELETED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
