
package net.lightapi.portal.oauth.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This endpoint will be called by oauth-kafka and portal UI to remove compromised authorization code by admin.
 *
 * client credentials token will be used if called from the oauth-kafka
 * authorization code token will be used if called from the Portal UI.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/oauth/deleteProvider/0.1.0")
public class DeleteProvider extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteProvider.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.AUTH_PROVIDER_DELETED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
