
package net.lightapi.portal.oauth.command.handler;

import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import com.networknt.utility.HashUtil;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;

/**
 * create a client for the host.
 */
@ServiceHandler(id="lightapi.net/oauth/createClient/0.1.0")
public class CreateClient extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateClient.class);
    private static final String ERROR_HASHING_PASSWORD = "ERR11614";

    @Override
    protected String getCloudEventType() {
        return PortalConstants.CLIENT_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        // generate client_id and client_secret here.
        String clientId = UuidUtil.getUUID().toString();
        String clientSecret = UuidUtil.uuidToBase64(UuidUtil.getUUID());
        String clientSecretEncrypted = null;
        try {
            clientSecretEncrypted = HashUtil.generateStrongPasswordHash(clientSecret);
            map.put("clientSecret", clientSecretEncrypted);
            map.put("clientId", clientId);
        } catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            logger.error("Exception:", e);
            return Failure.of(new Status(ERROR_HASHING_PASSWORD, e.getMessage()));
        }
        return Success.of(map);
    }
}
