
package net.lightapi.portal.oauth.command.handler;

import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Create am authorization code from oauth-kafka code service. A client credentials token is needed to access
 * this endpoint and the userId is passed from the payload. When this request is called, there is no user token
 * available, so only client credentials token is used to authorize the request. The userId is passed in the
 * data section.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/oauth/createAuthCode/0.1.0")
public class CreateAuthCode extends AbstractCommandHandler {
    public static final Logger logger = LoggerFactory.getLogger(CreateAuthCode.class);

    @Override
    public String getCloudEventType() {
        return PortalConstants.AUTH_CODE_CREATED_EVENT;
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> validateTokenType(String userId, Map<String, Object> map) {
        // call from the oauth-kafka with client credentials token only.
        if (userId != null) {
            logger.error("Incorrect token type: userId is not null. Must be Client Credentials Token.");
            return Failure.of(new Status(INCORRECT_TOKEN_TYPE, "Client Credentials Token"));
        }
        return Success.of(map);
    }

}
