/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.instance.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/instance/getInstanceApiLabel/0.1.0")
public class GetInstanceApiLabel
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetInstanceApiLabel.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        String instanceId = (String)map.get("instanceId");
        if (logger.isTraceEnabled()) {
            logger.trace("hostId = {}, instanceId = {}", (Object)hostId, (Object)instanceId);
        }
        if ((result = dbProvider.getInstanceApiLabel(hostId, instanceId)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{String.format("instance api label with hostId = %s, instanceId = %s", hostId, instanceId)}));
        }
        return NioUtils.toByteBuffer((String)((String)result.getResult()));
    }
}

