
package net.lightapi.portal.instance.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * getInstanceAppApi is a query side handler to get the application API for an instance.
*/
@ServiceHandler(id="lightapi.net/instance/getInstanceAppApi/0.1.0")
public class GetInstanceAppApi implements HybridHandler {
    public static final Logger logger = LoggerFactory.getLogger(GetInstanceApi.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        if(StringUtils.isBlank(hostId)) hostId = null;
        String instanceAppId = (String)map.get("instanceAppId");
        if(StringUtils.isBlank(instanceAppId)) instanceAppId = null;
        String instanceApiId = (String)map.get("instanceApiId");
        if(StringUtils.isBlank(instanceApiId)) instanceApiId = null;
        String instanceId = (String)map.get("instanceId");
        if(StringUtils.isBlank(instanceId)) instanceId = null;
        String instanceName = (String)map.get("instanceName");
        if(StringUtils.isBlank(instanceName)) instanceName = null;
        String productId = (String)map.get("productId");
        if(StringUtils.isBlank(productId)) productId = null;
        String productVersion = (String)map.get("productVersion");
        if(StringUtils.isBlank(productVersion)) productVersion = null;
        String appId = (String)map.get("appId");
        if(StringUtils.isBlank(appId)) appId = null;
        String appVersion = (String)map.get("appVersion");
        if(StringUtils.isBlank(appVersion)) appVersion = null;

        String apiVersionId = (String)map.get("apiVersionId");
        if(StringUtils.isBlank(apiVersionId)) apiVersionId = null;
        String apiId = (String)map.get("apiId");
        if(StringUtils.isBlank(apiId)) apiId = null;
        String apiVersion = (String)map.get("apiVersion");
        if(StringUtils.isBlank(apiVersion)) apiVersion = null;
        Boolean active = (Boolean)map.get("active");

        Result<String> result = dbProvider.getInstanceAppApi(offset, limit, hostId, instanceAppId, instanceApiId,
                instanceId, instanceName, productId, productVersion,
                appId, appVersion, apiVersionId, apiId, apiVersion, active);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "instance app api", hostId));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
