package net.lightapi.portal.instance.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get instance by hostId and filters with pagination
*/
@ServiceHandler(id="lightapi.net/instance/getInstance/0.1.0")
public class GetInstance implements HybridHandler {
    public static final Logger logger = LoggerFactory.getLogger(GetInstance.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        if(StringUtils.isBlank(hostId)) hostId = null;

        String instanceId = (String)map.get("instanceId");
        if(StringUtils.isBlank(instanceId)) instanceId = null;
        String instanceName = (String)map.get("instanceName");
        if(StringUtils.isBlank(instanceName)) instanceName = null;
        String productVersionId = (String)map.get("productVersionId");
        if(StringUtils.isBlank(productVersionId)) productVersionId = null;
        String productId = (String)map.get("productId");
        if(StringUtils.isBlank(productId)) productId = null;
        String productVersion = (String)map.get("productVersion");
        if(StringUtils.isBlank(productVersion)) productVersion = null;
        String serviceId = (String)map.get("serviceId");
        if(StringUtils.isBlank(serviceId)) serviceId = null;

        Boolean current = (Boolean)map.get("current");
        Boolean readonly = (Boolean)map.get("readonly");

        String environment = (String)map.get("environment");
        if(StringUtils.isBlank(environment)) environment = null;
        String serviceDesc = (String)map.get("serviceDesc");
        if(StringUtils.isBlank(serviceDesc)) serviceDesc = null;
        String instanceDesc = (String)map.get("instanceDesc");
        if(StringUtils.isBlank(instanceDesc)) instanceDesc = null;

        String zone = (String)map.get("zone");
        if(StringUtils.isBlank(zone)) zone = null;
        String region = (String)map.get("region");
        if(StringUtils.isBlank(region)) region = null;
        String lob = (String)map.get("lob");
        if(StringUtils.isBlank(lob)) lob = null;
        String resourceName = (String)map.get("resourceName");
        if(StringUtils.isBlank(resourceName)) resourceName = null;
        String businessName = (String)map.get("businessName");
        if(StringUtils.isBlank(businessName)) businessName = null;
        String envTag = (String)map.get("envTag");
        if(StringUtils.isBlank(envTag)) envTag = null;
        String topicClassification = (String)map.get("topicClassification");
        if(StringUtils.isBlank(topicClassification)) topicClassification = null;

        Result<String> result = dbProvider.getInstance(offset, limit, hostId, instanceId, instanceName,
                productVersionId, productId, productVersion, serviceId,
                current, readonly, environment, serviceDesc,
                instanceDesc, zone, region, lob, resourceName,
                businessName, envTag, topicClassification);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "instance", hostId));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
