/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.instance.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/instance/getInstancePipeline/0.1.0")
public class GetInstancePipeline
implements HybridHandler {
    public static final Logger logger = LoggerFactory.getLogger(GetInstancePipeline.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String pipelineVersion;
        String pipelineName;
        String platformVersion;
        String platformName;
        String pipelineId;
        String productVersion;
        String productId;
        String instanceName;
        String instanceId;
        Map map = (Map)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        if (StringUtils.isBlank((CharSequence)hostId)) {
            hostId = null;
        }
        if (StringUtils.isBlank((CharSequence)(instanceId = (String)map.get("instanceId")))) {
            instanceId = null;
        }
        if (StringUtils.isBlank((CharSequence)(instanceName = (String)map.get("instanceName")))) {
            instanceName = null;
        }
        if (StringUtils.isBlank((CharSequence)(productId = (String)map.get("productId")))) {
            productId = null;
        }
        if (StringUtils.isBlank((CharSequence)(productVersion = (String)map.get("productVersion")))) {
            productVersion = null;
        }
        if (StringUtils.isBlank((CharSequence)(pipelineId = (String)map.get("pipelineId")))) {
            pipelineId = null;
        }
        if (StringUtils.isBlank((CharSequence)(platformName = (String)map.get("platformName")))) {
            platformName = null;
        }
        if (StringUtils.isBlank((CharSequence)(platformVersion = (String)map.get("platformVersion")))) {
            platformVersion = null;
        }
        if (StringUtils.isBlank((CharSequence)(pipelineName = (String)map.get("pipelineName")))) {
            pipelineName = null;
        }
        if (StringUtils.isBlank((CharSequence)(pipelineVersion = (String)map.get("pipelineVersion")))) {
            pipelineVersion = null;
        }
        if ((result = dbProvider.getInstancePipeline(offset, limit, hostId, instanceId, instanceName, productId, productVersion, pipelineId, platformName, platformVersion, pipelineName, pipelineVersion)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"instance app", hostId}));
        }
        return NioUtils.toByteBuffer((String)((String)result.getResult()));
    }
}

