
package net.lightapi.portal.instance.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get instance app by hostId and filters with pagination
*/
@ServiceHandler(id="lightapi.net/instance/getInstanceApp/0.1.0")
public class GetInstanceApp implements HybridHandler {
    public static final Logger logger = LoggerFactory.getLogger(GetInstanceApp.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        if(StringUtils.isBlank(hostId)) hostId = null;
        String instanceAppId = (String)map.get("instanceAppId");
        if(StringUtils.isBlank(instanceAppId)) instanceAppId = null;
        String instanceId = (String)map.get("instanceId");
        if(StringUtils.isBlank(instanceId)) instanceId = null;
        String instanceName = (String)map.get("instanceName");
        if(StringUtils.isBlank(instanceName)) instanceName = null;
        String productId = (String)map.get("productId");
        if(StringUtils.isBlank(productId)) productId = null;
        String productVersion = (String)map.get("productVersion");
        if(StringUtils.isBlank(productVersion)) productVersion = null;
        String appId = (String)map.get("appId");
        if(StringUtils.isBlank(appId)) appId = null;
        String appVersion = (String)map.get("appVersion");
        if(StringUtils.isBlank(appVersion)) appVersion = null;
        Boolean active = (Boolean)map.get("active");

        Result<String> result = dbProvider.getInstanceApp(offset, limit, hostId, instanceAppId, instanceId, instanceName,
                productId, productVersion, appId, appVersion, active);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "instance app", hostId));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
