
package net.lightapi.portal.instance.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * getInstanceApiPathPrefix is a query side handler to get the path prefix for an instance API.
*/
@ServiceHandler(id="lightapi.net/instance/getInstanceApiPathPrefix/0.1.0")
public class GetInstanceApiPathPrefix implements HybridHandler {
    public static final Logger logger = LoggerFactory.getLogger(GetInstanceApi.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        if(StringUtils.isBlank(hostId)) hostId = null;

        String instanceApiId = (String)map.get("instanceApiId");
        if(StringUtils.isBlank(instanceApiId)) instanceApiId = null;
        String instanceId = (String)map.get("instanceId");
        if(StringUtils.isBlank(instanceId)) instanceId = null;
        String instanceName = (String)map.get("instanceName");
        if(StringUtils.isBlank(instanceName)) instanceName = null;
        String productId = (String)map.get("productId");
        if(StringUtils.isBlank(productId)) productId = null;
        String productVersion = (String)map.get("productVersion");
        if(StringUtils.isBlank(productVersion)) productVersion = null;
        String apiVersionId = (String)map.get("apiVersionId");
        if(StringUtils.isBlank(apiVersionId)) apiVersionId = null;
        String apiId = (String)map.get("apiId");
        if(StringUtils.isBlank(apiId)) apiId = null;
        String apiVersion = (String)map.get("apiVersion");
        if(StringUtils.isBlank(apiVersion)) apiVersion = null;
        String pathPrefix = (String)map.get("pathPrefix");
        if(StringUtils.isBlank(pathPrefix)) pathPrefix = null;

        Result<String> result = dbProvider.getInstanceApiPathPrefix(offset, limit, hostId, instanceApiId, instanceId, instanceName,
                productId, productVersion, apiVersionId, apiId, apiVersion, pathPrefix);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "instance api path prefix", hostId));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
