
package net.lightapi.portal.instance.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * update an instance pipeline for a gateway instance within a host.
*/
@ServiceHandler(id="lightapi.net/instance/updateInstancePipeline/0.1.0")
public class UpdateInstancePipeline extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateInstancePipeline.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_PIPELINE_UPDATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_INSTANCE;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the instanceId in the data section.
        return (String) map.get("instanceId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
