
package net.lightapi.portal.instance.command.handler;

import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * updateInstanceAppApi is a command side handler to update an application API for an instance.
*/
@ServiceHandler(id="lightapi.net/instance/updateInstanceAppApi/0.1.0")
public class UpdateInstanceAppApi extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateInstanceAppApi.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_APP_API_UPDATED_EVENT;
    }
    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_INSTANCE_APP_API;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the instanceAppId|instanceApiId in the data section.
        return map.get("instanceAppId") + "|" + map.get("instanceApiId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
