
package net.lightapi.portal.instance.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * update an instance app for a gateway instance within a host.
*/
@ServiceHandler(id="lightapi.net/instance/updateInstanceApp/0.1.0")
public class UpdateInstanceApp extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateInstanceApp.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_APP_UPDATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_INSTANCE_APP;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the instanceAppId in the data section.
        return (String) map.get("instanceAppId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
