
package net.lightapi.portal.instance.command.handler;

import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * updateInstanceApiPathPrefix is a command side handler to update a path prefix for an instance API.
*/
@ServiceHandler(id="lightapi.net/instance/updateInstanceApiPathPrefix/0.1.0")
public class UpdateInstanceApiPathPrefix extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateInstanceApiPathPrefix.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_API_PATH_PREFIX_UPDATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_INSTANCE_API;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the instanceApiId in the data section.
        return (String) map.get("instanceApiId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
