
package net.lightapi.portal.instance.command.handler;

import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * delete an instance pipeline for a gateway instance within a host.
*/
@ServiceHandler(id="lightapi.net/instance/deleteInstancePipeline/0.1.0")
public class DeleteInstancePipeline extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteInstancePipeline.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_PIPELINE_DELETED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_INSTANCE;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the instanceId in the data section.
        return (String) map.get("instanceId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
