
package net.lightapi.portal.instance.command.handler;

import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * deleteInstanceAppApi is a command side handler to delete an application API for an instance.
*/
@ServiceHandler(id="lightapi.net/instance/deleteInstanceAppApi/0.1.0")
public class DeleteInstanceAppApi extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteInstanceAppApi.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_APP_API_DELETED_EVENT;
    }
    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_INSTANCE_APP_API;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the instanceAppId|instanceApiId in the data section.
        return map.get("instanceAppId") + "|" + map.get("instanceApiId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
