
package net.lightapi.portal.instance.command.handler;

import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * createInstanceApiPathPrefix is a command side handler to create a path prefix for an instance API.
*/
@ServiceHandler(id="lightapi.net/instance/createInstanceApiPathPrefix/0.1.0")
public class CreateInstanceApiPathPrefix extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateInstanceApiPathPrefix.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_API_PATH_PREFIX_CREATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_INSTANCE_API;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the instanceApiId in the data section.
        return (String) map.get("instanceApiId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
