
package net.lightapi.portal.instance.command.handler;

import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * updateInstanceAppApi is a command side handler to update an application API for an instance.
*/
@ServiceHandler(id="lightapi.net/instance/updateInstanceAppApi/0.1.0")
public class UpdateInstanceAppApi extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateInstanceAppApi.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_APP_API_UPDATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
