
package net.lightapi.portal.instance.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * update an instance app for a gateway instance within a host.
*/
@ServiceHandler(id="lightapi.net/instance/updateInstanceApp/0.1.0")
public class UpdateInstanceApp extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateInstanceApp.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_APP_UPDATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
