
package net.lightapi.portal.instance.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * update an instance api for a gateway instance within a host.
*/
@ServiceHandler(id="lightapi.net/instance/updateInstanceApi/0.1.0")
public class UpdateInstanceApi extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateInstanceApi.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_API_UPDATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
