
package net.lightapi.portal.instance.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * create an instance pipeline for a gateway instance within a host.
*/
@ServiceHandler(id="lightapi.net/instance/createInstancePipeline/0.1.0")
public class CreateInstancePipeline extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateInstancePipeline.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_PIPELINE_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
