
package net.lightapi.portal.instance.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * create an instance app for a gateway instance within a host.
*/
@ServiceHandler(id="lightapi.net/instance/createInstanceApp/0.1.0")
public class CreateInstanceApp extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateInstanceApp.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_APP_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("instanceAppId", UuidUtil.getUUID());
        return Success.of(map);
    }

}
