
package net.lightapi.portal.instance.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.Util;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * create an instance for the host
*/
@ServiceHandler(id="lightapi.net/instance/createInstance/0.1.0")
public class CreateInstance extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateInstance.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("instanceId", UuidUtil.getUUID());
        return Success.of(map);
    }
}
