/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio._private.Messages;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.Channels;
import org.xnio.channels.CloseableChannel;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.SuspendableReadChannel;
import org.xnio.channels.SuspendableWriteChannel;
import org.xnio.channels.WritableMessageChannel;

public final class ChannelListeners {
    private static final ChannelListener<Channel> NULL_LISTENER = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
        }

        public String toString() {
            return "Null channel listener";
        }
    };
    private static final ChannelListener.Setter<?> NULL_SETTER = new ChannelListener.Setter<Channel>(){

        @Override
        public void set(ChannelListener<? super Channel> channelListener) {
        }

        public String toString() {
            return "Null channel listener setter";
        }
    };
    private static ChannelListener<Channel> CLOSING_CHANNEL_LISTENER = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
            IoUtils.safeClose((Closeable)channel);
        }

        public String toString() {
            return "Closing channel listener";
        }
    };
    private static final ChannelExceptionHandler<Channel> CLOSING_HANDLER = new ChannelExceptionHandler<Channel>(){

        @Override
        public void handleException(Channel channel, IOException exception) {
            IoUtils.safeClose((Closeable)channel);
        }
    };

    private ChannelListeners() {
    }

    public static <T extends Channel> boolean invokeChannelListener(T channel, ChannelListener<? super T> channelListener) {
        if (channelListener != null) {
            try {
                Messages.listenerMsg.tracef("Invoking listener %s on channel %s", (Object)channelListener, (Object)channel);
                channelListener.handleEvent(channel);
            }
            catch (Throwable t2) {
                Messages.listenerMsg.listenerException(t2);
                return false;
            }
        }
        return true;
    }

    public static <T extends Channel> void invokeChannelListener(Executor executor, T channel, ChannelListener<? super T> channelListener) {
        if (channelListener != null) {
            try {
                executor.execute(ChannelListeners.getChannelListenerTask(channel, channelListener));
            }
            catch (RejectedExecutionException ree) {
                ChannelListeners.invokeChannelListener(channel, channelListener);
            }
        }
    }

    public static <T extends Channel> void invokeChannelExceptionHandler(T channel, ChannelExceptionHandler<? super T> exceptionHandler, IOException exception) {
        if (exceptionHandler != null) {
            try {
                exceptionHandler.handleException(channel, exception);
            }
            catch (Throwable t2) {
                Messages.listenerMsg.exceptionHandlerException(t2);
            }
        }
    }

    public static <T extends Channel> Runnable getChannelListenerTask(final T channel, final ChannelListener<? super T> channelListener) {
        return new Runnable(){

            public String toString() {
                return "Channel listener task for " + channel + " -> " + channelListener;
            }

            @Override
            public void run() {
                ChannelListeners.invokeChannelListener(channel, channelListener);
            }
        };
    }

    public static <T extends Channel> Runnable getChannelListenerTask(final T channel, final ChannelListener.SimpleSetter<T> setter) {
        return new Runnable(){

            public String toString() {
                return "Channel listener task for " + channel + " -> " + setter;
            }

            @Override
            public void run() {
                ChannelListeners.invokeChannelListener(channel, setter.get());
            }
        };
    }

    public static ChannelListener<Channel> closingChannelListener() {
        return CLOSING_CHANNEL_LISTENER;
    }

    public static ChannelListener<Channel> closingChannelListener(final Closeable resource) {
        return new ChannelListener<Channel>(){

            @Override
            public void handleEvent(Channel channel) {
                IoUtils.safeClose(resource);
            }

            public String toString() {
                return "Closing channel listener for " + resource;
            }
        };
    }

    public static ChannelListener<Channel> closingChannelListener(final Closeable ... resources) {
        return new ChannelListener<Channel>(){

            @Override
            public void handleEvent(Channel channel) {
                IoUtils.safeClose(resources);
            }

            public String toString() {
                return "Closing channel listener for " + resources.length + " items";
            }
        };
    }

    public static <T extends Channel> ChannelListener<T> closingChannelListener(final ChannelListener<T> delegate, final Closeable resource) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                IoUtils.safeClose(resource);
                delegate.handleEvent(channel);
            }

            public String toString() {
                return "Closing channel listener for " + resource + " -> " + delegate;
            }
        };
    }

    public static <T extends Channel> ChannelListener<T> closingChannelListener(final ChannelListener<T> delegate, final Closeable ... resources) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                IoUtils.safeClose(resources);
                delegate.handleEvent(channel);
            }

            public String toString() {
                return "Closing channel listener for " + resources.length + " items -> " + delegate;
            }
        };
    }

    public static ChannelListener<Channel> nullChannelListener() {
        return NULL_LISTENER;
    }

    public static ChannelExceptionHandler<Channel> closingChannelExceptionHandler() {
        return CLOSING_HANDLER;
    }

    public static <C extends ConnectedChannel> ChannelListener<AcceptingChannel<C>> openListenerAdapter(final ChannelListener<? super C> openListener) {
        if (openListener == null) {
            throw Messages.msg.nullParameter("openListener");
        }
        return new ChannelListener<AcceptingChannel<C>>(){

            @Override
            public void handleEvent(AcceptingChannel<C> channel) {
                try {
                    CloseableChannel accepted = channel.accept();
                    if (accepted != null) {
                        ChannelListeners.invokeChannelListener(accepted, openListener);
                    }
                }
                catch (IOException e) {
                    Messages.listenerMsg.acceptFailed(channel, e);
                }
            }

            public String toString() {
                return "Accepting listener for " + openListener;
            }
        };
    }

    @Deprecated
    public static <T extends Channel, C> ChannelListener.Setter<T> getSetter(final C channel, final AtomicReferenceFieldUpdater<C, ChannelListener> updater) {
        return new ChannelListener.Setter<T>(){

            @Override
            public void set(ChannelListener<? super T> channelListener) {
                updater.set(channel, channelListener);
            }

            public String toString() {
                return "Atomic reference field updater setter for " + updater;
            }
        };
    }

    public static <T extends Channel> ChannelListener.Setter<T> getSetter(final AtomicReference<ChannelListener<? super T>> atomicReference) {
        return new ChannelListener.Setter<T>(){

            @Override
            public void set(ChannelListener<? super T> channelListener) {
                atomicReference.set(channelListener);
            }

            public String toString() {
                return "Atomic reference setter (currently=" + atomicReference.get() + ")";
            }
        };
    }

    public static <T extends Channel> ChannelListener.Setter<T> getDelegatingSetter(ChannelListener.Setter<? extends Channel> target, T realChannel) {
        return target == null ? null : new DelegatingSetter<T>(target, realChannel);
    }

    public static <T extends Channel> ChannelListener.Setter<T> nullSetter() {
        return NULL_SETTER;
    }

    public static <T extends Channel> ChannelListener<T> executorChannelListener(final ChannelListener<T> listener, final Executor executor) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                try {
                    executor.execute(ChannelListeners.getChannelListenerTask(channel, listener));
                }
                catch (RejectedExecutionException e) {
                    Messages.listenerMsg.executorSubmitFailed(e, (Channel)channel);
                    IoUtils.safeClose(channel);
                }
            }

            public String toString() {
                return "Executor channel listener -> " + listener;
            }
        };
    }

    public static <T extends SuspendableWriteChannel> ChannelListener<T> flushingChannelListener(final ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                boolean result2;
                try {
                    result2 = channel.flush();
                }
                catch (IOException e) {
                    channel.suspendWrites();
                    ChannelListeners.invokeChannelExceptionHandler(channel, exceptionHandler, e);
                    return;
                }
                if (result2) {
                    Channels.setWriteListener(channel, delegate);
                    ChannelListeners.invokeChannelListener(channel, delegate);
                } else {
                    Channels.setWriteListener(channel, this);
                    channel.resumeWrites();
                }
            }

            public String toString() {
                return "Flushing channel listener -> " + delegate;
            }
        };
    }

    public static <T extends SuspendableWriteChannel> ChannelListener<T> writeShutdownChannelListener(final ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        final ChannelListener<? super T> flushingListener = ChannelListeners.flushingChannelListener(delegate, exceptionHandler);
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                try {
                    channel.shutdownWrites();
                }
                catch (IOException e) {
                    ChannelListeners.invokeChannelExceptionHandler(channel, exceptionHandler, e);
                    return;
                }
                ChannelListeners.invokeChannelListener(channel, flushingListener);
            }

            public String toString() {
                return "Write shutdown channel listener -> " + delegate;
            }
        };
    }

    public static <T extends StreamSinkChannel> ChannelListener<T> writingChannelListener(final Pooled<ByteBuffer> pooled, final ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        return new ChannelListener<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(T channel) {
                ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                boolean ok = false;
                do {
                    int result2;
                    try {
                        result2 = channel.write(buffer);
                        ok = true;
                    }
                    catch (IOException e) {
                        channel.suspendWrites();
                        pooled.free();
                        ChannelListeners.invokeChannelExceptionHandler(channel, exceptionHandler, e);
                        return;
                    }
                    finally {
                        if (!ok) {
                            pooled.free();
                        }
                    }
                    if (result2 != 0) continue;
                    Channels.setWriteListener(channel, this);
                    channel.resumeWrites();
                    return;
                } while (buffer.hasRemaining());
                pooled.free();
                ChannelListeners.invokeChannelListener(channel, delegate);
            }

            public String toString() {
                return "Writing channel listener -> " + delegate;
            }
        };
    }

    public static <T extends WritableMessageChannel> ChannelListener<T> sendingChannelListener(final Pooled<ByteBuffer> pooled, final ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        return new ChannelListener<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(T channel) {
                ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                boolean free = true;
                try {
                    free = channel.send(buffer);
                    if (!free) {
                        Channels.setWriteListener(channel, this);
                        channel.resumeWrites();
                        return;
                    }
                }
                catch (IOException e) {
                    channel.suspendWrites();
                    pooled.free();
                    ChannelListeners.invokeChannelExceptionHandler(channel, exceptionHandler, e);
                    return;
                }
                finally {
                    if (free) {
                        pooled.free();
                    }
                }
                ChannelListeners.invokeChannelListener(channel, delegate);
            }

            public String toString() {
                return "Sending channel listener -> " + delegate;
            }
        };
    }

    public static <T extends StreamSinkChannel> ChannelListener<T> fileSendingChannelListener(final FileChannel source2, final long position, final long count, final ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        if (count == 0L) {
            return ChannelListeners.delegatingChannelListener(delegate);
        }
        return new ChannelListener<T>(){
            private long p;
            private long cnt;
            {
                this.p = position;
                this.cnt = count;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(T channel) {
                long cnt = this.cnt;
                long p = this.p;
                try {
                    long result2;
                    do {
                        try {
                            result2 = channel.transferFrom(source2, p, cnt);
                        }
                        catch (IOException e) {
                            ChannelListeners.invokeChannelExceptionHandler(channel, exceptionHandler, e);
                            this.p = p;
                            this.cnt = cnt;
                            return;
                        }
                        if (result2 == 0L) {
                            Channels.setWriteListener(channel, this);
                            channel.resumeWrites();
                            return;
                        }
                        p += result2;
                    } while ((cnt -= result2) > 0L);
                    ChannelListeners.invokeChannelListener(channel, delegate);
                    return;
                }
                finally {
                    this.p = p;
                    this.cnt = cnt;
                }
            }

            public String toString() {
                return "File sending channel listener (" + source2 + ") -> " + delegate;
            }
        };
    }

    public static <T extends StreamSourceChannel> ChannelListener<T> fileReceivingChannelListener(final FileChannel target, final long position, final long count, final ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        if (count == 0L) {
            return ChannelListeners.delegatingChannelListener(delegate);
        }
        return new ChannelListener<T>(){
            private long p;
            private long cnt;
            {
                this.p = position;
                this.cnt = count;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(T channel) {
                long cnt = this.cnt;
                long p = this.p;
                try {
                    long result2;
                    do {
                        try {
                            result2 = channel.transferTo(p, cnt, target);
                        }
                        catch (IOException e) {
                            ChannelListeners.invokeChannelExceptionHandler(channel, exceptionHandler, e);
                            this.p = p;
                            this.cnt = cnt;
                            return;
                        }
                        if (result2 == 0L) {
                            Channels.setReadListener(channel, this);
                            channel.resumeReads();
                            return;
                        }
                        p += result2;
                    } while ((cnt -= result2) > 0L);
                    ChannelListeners.invokeChannelListener(channel, delegate);
                    return;
                }
                finally {
                    this.p = p;
                    this.cnt = cnt;
                }
            }

            public String toString() {
                return "File receiving channel listener (" + target + ") -> " + delegate;
            }
        };
    }

    public static <T extends Channel> ChannelListener<T> delegatingChannelListener(final ChannelListener<? super T> delegate) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                ChannelListeners.invokeChannelListener(channel, delegate);
            }

            public String toString() {
                return "Delegating channel listener -> " + delegate;
            }
        };
    }

    public static <C extends Channel, T extends Channel> ChannelListener<C> delegatingChannelListener(T channel, ChannelListener.SimpleSetter<T> setter) {
        return new SetterDelegatingListener(setter, channel);
    }

    public static <T extends SuspendableWriteChannel> ChannelListener<T> writeSuspendingChannelListener(final ChannelListener<? super T> delegate) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                channel.suspendWrites();
                ChannelListeners.invokeChannelListener(channel, delegate);
            }

            public String toString() {
                return "Write-suspending channel listener -> " + delegate;
            }
        };
    }

    public static <T extends SuspendableReadChannel> ChannelListener<T> readSuspendingChannelListener(final ChannelListener<? super T> delegate) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                channel.suspendReads();
                ChannelListeners.invokeChannelListener(channel, delegate);
            }

            public String toString() {
                return "Read-suspending channel listener -> " + delegate;
            }
        };
    }

    public static <I extends StreamSourceChannel, O extends StreamSinkChannel> void initiateTransfer(I source2, O sink2, Pool<ByteBuffer> pool) {
        ChannelListeners.initiateTransfer(Long.MAX_VALUE, source2, sink2, CLOSING_CHANNEL_LISTENER, CLOSING_CHANNEL_LISTENER, CLOSING_HANDLER, CLOSING_HANDLER, pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends StreamSourceChannel, O extends StreamSinkChannel> void initiateTransfer(long count, I source2, O sink2, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener, ChannelExceptionHandler<? super I> readExceptionHandler, ChannelExceptionHandler<? super O> writeExceptionHandler, Pool<ByteBuffer> pool) {
        if (pool == null) {
            throw Messages.msg.nullParameter("pool");
        }
        Pooled<ByteBuffer> allocated = pool.allocate();
        boolean free = true;
        try {
            block31: {
                ByteBuffer buffer = allocated.getResource();
                do {
                    long transferred;
                    try {
                        transferred = source2.transferTo(count, buffer, sink2);
                    }
                    catch (IOException e) {
                        ChannelListeners.invokeChannelExceptionHandler(source2, readExceptionHandler, e);
                        if (free) {
                            allocated.free();
                        }
                        return;
                    }
                    if (transferred == 0L && !buffer.hasRemaining()) break block31;
                    if (transferred == -1L) {
                        if (count == Long.MAX_VALUE) {
                            Channels.setReadListener(source2, sourceListener);
                            if (sourceListener == null) {
                                source2.suspendReads();
                            } else {
                                source2.wakeupReads();
                            }
                            Channels.setWriteListener(sink2, sinkListener);
                            if (sinkListener == null) {
                                sink2.suspendWrites();
                            } else {
                                sink2.wakeupWrites();
                            }
                        } else {
                            source2.suspendReads();
                            sink2.suspendWrites();
                            ChannelListeners.invokeChannelExceptionHandler(source2, readExceptionHandler, new EOFException());
                        }
                        return;
                    }
                    if (count != Long.MAX_VALUE) {
                        count -= transferred;
                    }
                    while (buffer.hasRemaining()) {
                        int res;
                        try {
                            res = sink2.write(buffer);
                        }
                        catch (IOException e) {
                            ChannelListeners.invokeChannelExceptionHandler(sink2, writeExceptionHandler, e);
                            if (free) {
                                allocated.free();
                            }
                            return;
                        }
                        if (res == 0) {
                            TransferListener<? super I, ? super O> listener = new TransferListener<I, O>(count, allocated, source2, sink2, sourceListener, sinkListener, writeExceptionHandler, readExceptionHandler, 1);
                            source2.suspendReads();
                            source2.getReadSetter().set(listener);
                            sink2.getWriteSetter().set(listener);
                            sink2.resumeWrites();
                            free = false;
                            return;
                        }
                        if (count == Long.MAX_VALUE) continue;
                        count -= (long)res;
                    }
                } while (count != 0L);
                Channels.setReadListener(source2, sourceListener);
                if (sourceListener == null) {
                    source2.suspendReads();
                } else {
                    source2.wakeupReads();
                }
                Channels.setWriteListener(sink2, sinkListener);
                if (sinkListener == null) {
                    sink2.suspendWrites();
                } else {
                    sink2.wakeupWrites();
                }
                return;
            }
            TransferListener<? super I, ? super O> listener = new TransferListener<I, O>(count, allocated, source2, sink2, sourceListener, sinkListener, writeExceptionHandler, readExceptionHandler, 0);
            sink2.suspendWrites();
            sink2.getWriteSetter().set(listener);
            source2.getReadSetter().set(listener);
            source2.resumeReads();
            free = false;
            return;
        }
        finally {
            if (free) {
                allocated.free();
            }
        }
    }

    public static <T extends StreamSourceChannel> ChannelListener<T> drainListener(long bytes, ChannelListener<? super T> finishListener, ChannelExceptionHandler<? super T> exceptionHandler) {
        return new DrainListener(finishListener, exceptionHandler, bytes);
    }

    private static class DrainListener<T extends StreamSourceChannel>
    implements ChannelListener<T> {
        private final ChannelListener<? super T> finishListener;
        private final ChannelExceptionHandler<? super T> exceptionHandler;
        private long count;

        private DrainListener(ChannelListener<? super T> finishListener, ChannelExceptionHandler<? super T> exceptionHandler, long count) {
            this.finishListener = finishListener;
            this.exceptionHandler = exceptionHandler;
            this.count = count;
        }

        @Override
        public void handleEvent(T channel) {
            try {
                long count = this.count;
                try {
                    while (true) {
                        long res;
                        if ((res = Channels.drain(channel, count)) == -1L || res == count) {
                            this.count = 0L;
                            ChannelListeners.invokeChannelListener(channel, this.finishListener);
                            return;
                        }
                        if (res == 0L) {
                            return;
                        }
                        if (count >= Long.MAX_VALUE) continue;
                        count -= res;
                    }
                }
                finally {
                    this.count = count;
                }
            }
            catch (IOException e) {
                this.count = 0L;
                if (this.exceptionHandler != null) {
                    ChannelListeners.invokeChannelExceptionHandler(channel, this.exceptionHandler, e);
                } else {
                    IoUtils.safeShutdownReads(channel);
                }
                return;
            }
        }

        public String toString() {
            return "Draining channel listener (" + this.count + " bytes) -> " + this.finishListener;
        }
    }

    private static class SetterDelegatingListener<C extends Channel, T extends Channel>
    implements ChannelListener<C> {
        private final ChannelListener.SimpleSetter<T> setter;
        private final T channel;

        public SetterDelegatingListener(ChannelListener.SimpleSetter<T> setter, T channel) {
            this.setter = setter;
            this.channel = channel;
        }

        @Override
        public void handleEvent(C channel) {
            ChannelListeners.invokeChannelListener(this.channel, this.setter.get());
        }

        public String toString() {
            return "Setter delegating channel listener -> " + this.setter;
        }
    }

    private static class DelegatingChannelListener<T extends Channel>
    implements ChannelListener<Channel> {
        private final ChannelListener<? super T> channelListener;
        private final T realChannel;

        public DelegatingChannelListener(ChannelListener<? super T> channelListener, T realChannel) {
            this.channelListener = channelListener;
            this.realChannel = realChannel;
        }

        @Override
        public void handleEvent(Channel channel) {
            ChannelListeners.invokeChannelListener(this.realChannel, this.channelListener);
        }

        public String toString() {
            return "Delegating channel listener -> " + this.channelListener;
        }
    }

    private static class DelegatingSetter<T extends Channel>
    implements ChannelListener.Setter<T> {
        private final ChannelListener.Setter<? extends Channel> setter;
        private final T realChannel;

        DelegatingSetter(ChannelListener.Setter<? extends Channel> setter, T realChannel) {
            this.setter = setter;
            this.realChannel = realChannel;
        }

        @Override
        public void set(ChannelListener<? super T> channelListener) {
            this.setter.set((ChannelListener<? extends Channel>)(channelListener == null ? null : new DelegatingChannelListener<T>(channelListener, this.realChannel)));
        }

        public String toString() {
            return "Delegating setter -> " + this.setter;
        }
    }

    static final class TransferListener<I extends StreamSourceChannel, O extends StreamSinkChannel>
    implements ChannelListener<Channel> {
        private final Pooled<ByteBuffer> pooledBuffer;
        private final I source;
        private final O sink;
        private final ChannelListener<? super I> sourceListener;
        private final ChannelListener<? super O> sinkListener;
        private final ChannelExceptionHandler<? super O> writeExceptionHandler;
        private final ChannelExceptionHandler<? super I> readExceptionHandler;
        private long count;
        private volatile int state;

        TransferListener(long count, Pooled<ByteBuffer> pooledBuffer, I source2, O sink2, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener, ChannelExceptionHandler<? super O> writeExceptionHandler, ChannelExceptionHandler<? super I> readExceptionHandler, int state) {
            this.count = count;
            this.pooledBuffer = pooledBuffer;
            this.source = source2;
            this.sink = sink2;
            this.sourceListener = sourceListener;
            this.sinkListener = sinkListener;
            this.writeExceptionHandler = writeExceptionHandler;
            this.readExceptionHandler = readExceptionHandler;
            this.state = state;
        }

        @Override
        public void handleEvent(Channel channel) {
            ByteBuffer buffer = this.pooledBuffer.getResource();
            int state = this.state;
            long count = this.count;
            switch (state) {
                case 0: {
                    do {
                        long lres;
                        try {
                            lres = this.source.transferTo(count, buffer, (StreamSinkChannel)this.sink);
                        }
                        catch (IOException e) {
                            this.readFailed(e);
                            return;
                        }
                        if (lres == 0L && !buffer.hasRemaining()) {
                            this.count = count;
                            return;
                        }
                        if (lres == -1L) {
                            if (count == Long.MAX_VALUE) {
                                this.done();
                                return;
                            }
                            this.readFailed(new EOFException());
                            return;
                        }
                        if (count != Long.MAX_VALUE) {
                            count -= lres;
                        }
                        while (buffer.hasRemaining()) {
                            int ires;
                            try {
                                ires = this.sink.write(buffer);
                            }
                            catch (IOException e) {
                                this.writeFailed(e);
                                return;
                            }
                            if (count != Long.MAX_VALUE) {
                                count -= (long)ires;
                            }
                            if (ires != 0) continue;
                            this.count = count;
                            this.state = 1;
                            this.source.suspendReads();
                            this.sink.resumeWrites();
                            return;
                        }
                    } while (count != 0L);
                    this.done();
                    return;
                }
                case 1: {
                    while (true) {
                        long lres;
                        if (buffer.hasRemaining()) {
                            int ires;
                            try {
                                ires = this.sink.write(buffer);
                            }
                            catch (IOException e) {
                                this.writeFailed(e);
                                return;
                            }
                            if (count != Long.MAX_VALUE) {
                                count -= (long)ires;
                            }
                            if (ires != 0) continue;
                            return;
                        }
                        try {
                            lres = this.source.transferTo(count, buffer, (StreamSinkChannel)this.sink);
                        }
                        catch (IOException e) {
                            this.readFailed(e);
                            return;
                        }
                        if (lres == 0L && !buffer.hasRemaining()) {
                            this.count = count;
                            this.state = 0;
                            this.sink.suspendWrites();
                            this.source.resumeReads();
                            return;
                        }
                        if (lres == -1L) {
                            if (count == Long.MAX_VALUE) {
                                this.done();
                                return;
                            }
                            this.readFailed(new EOFException());
                            return;
                        }
                        if (count != Long.MAX_VALUE) {
                            count -= lres;
                        }
                        if (count == 0L) break;
                    }
                    this.done();
                    return;
                }
            }
        }

        private void writeFailed(IOException e) {
            try {
                this.source.suspendReads();
                this.sink.suspendWrites();
                ChannelListeners.invokeChannelExceptionHandler(this.sink, this.writeExceptionHandler, e);
            }
            finally {
                this.pooledBuffer.free();
            }
        }

        private void readFailed(IOException e) {
            try {
                this.source.suspendReads();
                this.sink.suspendWrites();
                ChannelListeners.invokeChannelExceptionHandler(this.source, this.readExceptionHandler, e);
            }
            finally {
                this.pooledBuffer.free();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void done() {
            try {
                ChannelListener<? super I> sourceListener = this.sourceListener;
                ChannelListener<? super O> sinkListener = this.sinkListener;
                I source2 = this.source;
                O sink2 = this.sink;
                Channels.setReadListener(source2, sourceListener);
                if (sourceListener == null) {
                    source2.suspendReads();
                } else {
                    source2.wakeupReads();
                }
                Channels.setWriteListener(sink2, sinkListener);
                if (sinkListener == null) {
                    sink2.suspendWrites();
                } else {
                    sink2.wakeupWrites();
                }
            }
            finally {
                this.pooledBuffer.free();
            }
        }

        public String toString() {
            return "Transfer channel listener (" + this.source + " to " + this.sink + ") -> (" + this.sourceListener + " and " + this.sinkListener + ")";
        }
    }
}

