/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Unicode;

class HTMLEncoder
extends Encoder {
    private static final int ENCODE_AFFIX_CHAR_COUNT = 3;
    private static final char[] TAB = "&#9;".toCharArray();
    private static final char[] AMP = "&amp;".toCharArray();
    private static final char[] LT = "&lt;".toCharArray();
    private static final char[] GT = "&gt;".toCharArray();

    HTMLEncoder() {
    }

    @Override
    int maxEncodedLength(int n) {
        return n * 7;
    }

    @Override
    int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        block4: for (int i = off; i < n; ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '`': 
                case '\u0085': {
                    return i;
                }
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    continue block4;
                }
                default: {
                    if (Character.isHighSurrogate(ch)) {
                        if (i + 1 < n) {
                            if (Character.isLowSurrogate(input.charAt(i + 1))) {
                                int cp = Character.toCodePoint(ch, input.charAt(i + 1));
                                if (Unicode.isNonCharacter(cp)) {
                                    return i;
                                }
                                ++i;
                                continue block4;
                            }
                        } else {
                            return i;
                        }
                    }
                    if (!(ch <= '\u009f' || '\ud800' <= ch && ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef' || ch == '\u2028') && ch != '\u2029') continue block4;
                    return i;
                }
            }
        }
        return n;
    }

    static int append(char[] src, char[] out, int j) {
        System.arraycopy(src, 0, out, j, src.length);
        return j + src.length;
    }

    static int encode(int codePoint, char[] out, int j) {
        out[j++] = 38;
        out[j++] = 35;
        if (codePoint >= 1000) {
            out[j++] = (char)(codePoint / 1000 % 10 + 48);
        }
        if (codePoint >= 100) {
            out[j++] = (char)(codePoint / 100 % 10 + 48);
        }
        if (codePoint >= 10) {
            out[j++] = (char)(codePoint / 10 % 10 + 48);
        }
        out[j++] = (char)(codePoint % 10 + 48);
        out[j++] = 59;
        return j;
    }

    @Override
    CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        int i;
        char[] in = input.array();
        char[] out = output.array();
        int n = input.arrayOffset() + input.limit();
        int j = output.arrayOffset() + output.position();
        int m4 = output.arrayOffset() + output.limit();
        block9: for (i = input.arrayOffset() + input.position(); i < n; ++i) {
            char ch = in[i];
            switch (ch) {
                case '\t': {
                    if (j + TAB.length > m4) {
                        return HTMLEncoder.overflow(input, i, output, j);
                    }
                    j = HTMLEncoder.append(TAB, out, j);
                    continue block9;
                }
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '\'': 
                case '/': 
                case '=': 
                case '`': {
                    if (5 + j > m4) {
                        return HTMLEncoder.overflow(input, i, output, j);
                    }
                    j = HTMLEncoder.encode(ch, out, j);
                    continue block9;
                }
                case '\u0085': {
                    if (6 + j > m4) {
                        return HTMLEncoder.overflow(input, i, output, j);
                    }
                    j = HTMLEncoder.encode(ch, out, j);
                    continue block9;
                }
                case '&': {
                    if (j + AMP.length > m4) {
                        return HTMLEncoder.overflow(input, i, output, j);
                    }
                    j = HTMLEncoder.append(AMP, out, j);
                    continue block9;
                }
                case '<': {
                    if (j + LT.length > m4) {
                        return HTMLEncoder.overflow(input, i, output, j);
                    }
                    j = HTMLEncoder.append(LT, out, j);
                    continue block9;
                }
                case '>': {
                    if (j + GT.length > m4) {
                        return HTMLEncoder.overflow(input, i, output, j);
                    }
                    j = HTMLEncoder.append(GT, out, j);
                    continue block9;
                }
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    if (j >= m4) {
                        return HTMLEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = ch;
                    continue block9;
                }
                default: {
                    if (Character.isHighSurrogate(ch)) {
                        if (i + 1 < n) {
                            if (Character.isLowSurrogate(in[i + 1])) {
                                int cp = Character.toCodePoint(ch, in[i + 1]);
                                if (Unicode.isNonCharacter(cp)) {
                                    if (j >= m4) {
                                        return HTMLEncoder.overflow(input, i, output, j);
                                    }
                                    out[j++] = 45;
                                    ++i;
                                    continue block9;
                                }
                                if (j + 1 >= m4) {
                                    return HTMLEncoder.overflow(input, i, output, j);
                                }
                                out[j++] = ch;
                                out[j++] = in[++i];
                                continue block9;
                            }
                        } else if (!endOfInput) break block9;
                    }
                    if (j >= m4) {
                        return HTMLEncoder.overflow(input, i, output, j);
                    }
                    if (ch <= '\u009f' || '\ud800' <= ch && ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef') {
                        out[j++] = 45;
                        continue block9;
                    }
                    if (ch == '\u2028' || ch == '\u2029') {
                        if (7 + j > m4) {
                            return HTMLEncoder.overflow(input, i, output, j);
                        }
                        j = HTMLEncoder.encode(ch, out, j);
                        continue block9;
                    }
                    out[j++] = ch;
                }
            }
        }
        return HTMLEncoder.underflow(input, i, output, j);
    }
}

