/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.security.AccessController;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import org.jboss.threads.EnhancedViewExecutor;
import org.jboss.threads.JBossExecutors;
import org.wildfly.common.Assert;

public abstract class ViewExecutor
extends AbstractExecutorService {
    private volatile Thread.UncaughtExceptionHandler handler;
    private volatile Runnable terminationTask;

    ViewExecutor() {
    }

    @Override
    public final void shutdown() {
        this.shutdown(false);
    }

    public abstract void shutdown(boolean var1);

    public final Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.handler;
    }

    public final void setExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        Assert.checkNotNullParam("handler", handler);
        this.handler = handler;
    }

    public final Runnable getTerminationTask() {
        return this.terminationTask;
    }

    public final void setTerminationTask(Runnable terminationTask) {
        this.terminationTask = terminationTask;
    }

    public static Builder builder(Executor delegate) {
        Assert.checkNotNullParam("delegate", delegate);
        return new Builder(delegate);
    }

    protected void runTermination() {
        block5: {
            Runnable task = this.terminationTask;
            this.terminationTask = null;
            if (task != null) {
                try {
                    task.run();
                }
                catch (Throwable t2) {
                    Thread.UncaughtExceptionHandler configuredHandler = this.handler;
                    if (configuredHandler == null) break block5;
                    try {
                        this.handler.uncaughtException(Thread.currentThread(), t2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static int readIntPropertyPrefixed(String name2, int defVal) {
        try {
            return Integer.parseInt(ViewExecutor.readPropertyPrefixed(name2, Integer.toString(defVal)));
        }
        catch (NumberFormatException ignored) {
            return defVal;
        }
    }

    static String readPropertyPrefixed(String name2, String defVal) {
        return ViewExecutor.readProperty("org.jboss.threads.view-executor." + name2, defVal);
    }

    static String readProperty(String name2, String defVal) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(() -> ViewExecutor.readPropertyRaw(name2, defVal));
        }
        return ViewExecutor.readPropertyRaw(name2, defVal);
    }

    static String readPropertyRaw(String name2, String defVal) {
        return System.getProperty(name2, defVal);
    }

    public static final class Builder {
        private final Executor delegate;
        private int maxSize = 1;
        private int queueLimit = Integer.MAX_VALUE;
        private Thread.UncaughtExceptionHandler handler = JBossExecutors.loggingExceptionHandler();

        Builder(Executor delegate) {
            this.delegate = delegate;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public Builder setMaxSize(int maxSize) {
            Assert.checkMinimumParameter("maxSize", 1, maxSize);
            this.maxSize = maxSize;
            return this;
        }

        public int getQueueLimit() {
            return this.queueLimit;
        }

        public Builder setQueueLimit(int queueLimit) {
            Assert.checkMinimumParameter("queueLimit", 0, queueLimit);
            this.queueLimit = queueLimit;
            return this;
        }

        public Executor getDelegate() {
            return this.delegate;
        }

        public Thread.UncaughtExceptionHandler getUncaughtHandler() {
            return this.handler;
        }

        public Builder setUncaughtHandler(Thread.UncaughtExceptionHandler handler) {
            this.handler = handler;
            return this;
        }

        @Deprecated
        public int getQueueInitialSize() {
            return 0;
        }

        @Deprecated
        public Builder setQueueInitialSize(int queueInitialSize) {
            return this;
        }

        public ViewExecutor build() {
            return new EnhancedViewExecutor(Assert.checkNotNullParam("delegate", this.delegate), this.maxSize, this.queueLimit, this.handler);
        }
    }
}

