/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.everit.json.schema.InternalValidationException;
import org.everit.json.schema.JSONPointer;
import org.everit.json.schema.Schema;
import org.json.JSONArray;
import org.json.JSONObject;

public class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = 6192047123024651924L;
    private final StringBuilder pointerToViolation;
    private final String schemaLocation;
    private final transient Schema violatedSchema;
    private final List<ValidationException> causingExceptions;
    private final String keyword;

    private static int getViolationCount(List<ValidationException> causes) {
        int causeCount = causes.stream().mapToInt(ValidationException::getViolationCount).sum();
        return Math.max(1, causeCount);
    }

    private static List<String> getAllMessages(List<ValidationException> causes) {
        List messages = causes.stream().filter(cause -> cause.causingExceptions.isEmpty()).map(ValidationException::getMessage).collect(Collectors.toCollection(ArrayList::new));
        messages.addAll(causes.stream().filter(cause -> !cause.causingExceptions.isEmpty()).flatMap(cause -> ValidationException.getAllMessages(cause.getCausingExceptions()).stream()).collect(Collectors.toList()));
        return messages;
    }

    public static void throwFor(Schema rootFailingSchema, List<ValidationException> failures) {
        int failureCount = failures.size();
        if (failureCount == 0) {
            return;
        }
        if (failureCount == 1) {
            throw failures.get(0);
        }
        throw ValidationException.createWrappingException(rootFailingSchema, failures);
    }

    static ValidationException createWrappingException(Schema rootFailingSchema, List<ValidationException> failures) {
        return new InternalValidationException(rootFailingSchema, new StringBuilder("#"), ValidationException.getViolationCount(failures) + " schema violations found", new ArrayList<ValidationException>(failures), null, rootFailingSchema.getSchemaLocation());
    }

    @Deprecated
    public ValidationException(Class<?> expectedType, Object actualValue) {
        this(null, expectedType, actualValue);
    }

    public ValidationException(Schema violatedSchema, Class<?> expectedType, Object actualValue) {
        this(violatedSchema, expectedType, actualValue, "type");
    }

    @Deprecated
    public ValidationException(Schema violatedSchema, Class<?> expectedType, Object actualValue, String keyword) {
        this(violatedSchema, new StringBuilder("#"), "expected type: " + expectedType.getSimpleName() + ", found: " + (actualValue == null ? "null" : actualValue.getClass().getSimpleName()), Collections.emptyList(), keyword, null);
    }

    public ValidationException(Schema violatedSchema, Class<?> expectedType, Object actualValue, String keyword, String schemaLocation) {
        this(violatedSchema, new StringBuilder("#"), "expected type: " + expectedType.getSimpleName() + ", found: " + (actualValue == null ? "null" : actualValue.getClass().getSimpleName()), Collections.emptyList(), keyword, schemaLocation);
    }

    @Deprecated
    public ValidationException(Schema violatedSchema, String message) {
        this(violatedSchema, new StringBuilder("#"), message, Collections.emptyList());
    }

    @Deprecated
    public ValidationException(Schema violatedSchema, String message, String keyword) {
        this(violatedSchema, new StringBuilder("#"), message, Collections.emptyList(), keyword, null);
    }

    public ValidationException(Schema violatedSchema, String message, String keyword, String schemaLocation) {
        this(violatedSchema, new StringBuilder("#"), message, Collections.emptyList(), keyword, schemaLocation);
    }

    @Deprecated
    ValidationException(Schema violatedSchema, StringBuilder pointerToViolation, String message, List<ValidationException> causingExceptions) {
        this(violatedSchema, pointerToViolation, message, causingExceptions, null, null);
    }

    ValidationException(Schema violatedSchema, StringBuilder pointerToViolation, String message, List<ValidationException> causingExceptions, String keyword, String schemaLocation) {
        super(message);
        this.violatedSchema = violatedSchema;
        this.pointerToViolation = pointerToViolation;
        this.causingExceptions = Collections.unmodifiableList(causingExceptions);
        this.keyword = keyword;
        this.schemaLocation = schemaLocation;
    }

    @Deprecated
    public ValidationException(String message) {
        this((Schema)null, new StringBuilder("#"), message, Collections.emptyList());
    }

    private ValidationException(StringBuilder pointerToViolation, Schema violatedSchema, String message, List<ValidationException> causingExceptions, String keyword, String schemaLocation) {
        this(violatedSchema, pointerToViolation, message, causingExceptions, keyword, schemaLocation);
    }

    @Deprecated
    public ValidationException(Schema violatedSchema, String message, List<ValidationException> causingExceptions) {
        this(violatedSchema, new StringBuilder("#"), message, causingExceptions);
    }

    public List<ValidationException> getCausingExceptions() {
        return this.causingExceptions;
    }

    public List<String> getAllMessages() {
        if (this.causingExceptions.isEmpty()) {
            return Collections.singletonList(this.getMessage());
        }
        return new ArrayList<String>(ValidationException.getAllMessages(this.causingExceptions));
    }

    @Override
    public String getMessage() {
        return this.getPointerToViolation() + ": " + super.getMessage();
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    public String getPointerToViolation() {
        if (this.pointerToViolation == null) {
            return null;
        }
        return this.pointerToViolation.toString();
    }

    public Schema getViolatedSchema() {
        return this.violatedSchema;
    }

    public ValidationException prepend(String fragment) {
        return this.prepend(fragment, this.violatedSchema);
    }

    public ValidationException prepend(String fragment, Schema violatedSchema) {
        String escapedFragment = JSONPointer.escape(Objects.requireNonNull(fragment, "fragment cannot be null"));
        StringBuilder newPointer = this.pointerToViolation.insert(1, '/').insert(2, escapedFragment);
        List<ValidationException> prependedCausingExceptions = this.causingExceptions.stream().map(exc -> exc.prepend(escapedFragment)).collect(Collectors.toList());
        return new InternalValidationException(violatedSchema, newPointer, super.getMessage(), prependedCausingExceptions, this.keyword, this.schemaLocation);
    }

    public int getViolationCount() {
        return ValidationException.getViolationCount(this.causingExceptions);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public JSONObject toJSON() {
        JSONObject rval = new JSONObject();
        rval.put("keyword", this.keyword);
        if (this.pointerToViolation == null) {
            rval.put("pointerToViolation", JSONObject.NULL);
        } else {
            rval.put("pointerToViolation", this.getPointerToViolation());
        }
        rval.put("message", super.getMessage());
        List causeJsons = this.causingExceptions.stream().map(ValidationException::toJSON).collect(Collectors.toList());
        rval.put("causingExceptions", new JSONArray(causeJsons));
        if (this.schemaLocation != null) {
            rval.put("schemaLocation", this.schemaLocation);
        }
        return rval;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationException that = (ValidationException)o;
        if (!this.pointerToViolation.toString().equals(that.pointerToViolation.toString())) {
            return false;
        }
        if (this.schemaLocation != null ? !this.schemaLocation.equals(that.schemaLocation) : that.schemaLocation != null) {
            return false;
        }
        if (!this.violatedSchema.equals(that.violatedSchema)) {
            return false;
        }
        if (!this.causingExceptions.equals(that.causingExceptions)) {
            return false;
        }
        return Objects.equals(this.keyword, that.keyword) && Objects.equals(this.getMessage(), that.getMessage());
    }

    public int hashCode() {
        int result2 = this.pointerToViolation == null ? 0 : this.pointerToViolation.hashCode();
        result2 = 31 * result2 + (this.schemaLocation != null ? this.schemaLocation.hashCode() : 0);
        result2 = 31 * result2 + (this.violatedSchema == null ? 0 : this.violatedSchema.hashCode());
        result2 = 31 * result2 + (this.causingExceptions == null ? 0 : this.causingExceptions.hashCode());
        result2 = 31 * result2 + (this.keyword == null ? 0 : this.keyword.hashCode());
        return result2;
    }

    ValidationException copy() {
        return new ValidationException(this.pointerToViolation, this.violatedSchema, super.getMessage(), this.causingExceptions, this.keyword, this.schemaLocation);
    }
}

