/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Objects;
import java.util.regex.Pattern;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.regexp.JavaUtilRegexpFactory;
import org.everit.json.schema.regexp.Regexp;

public class StringSchema
extends Schema {
    private final Integer minLength;
    private final Integer maxLength;
    private final Regexp pattern;
    private final boolean requiresString;
    private final FormatValidator formatValidator;

    public static Builder builder() {
        return new Builder();
    }

    public StringSchema() {
        this(StringSchema.builder());
    }

    public StringSchema(Builder builder) {
        super(builder);
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
        this.requiresString = builder.requiresString;
        this.pattern = builder.pattern;
        this.formatValidator = builder.formatValidator;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    Regexp getRegexpPattern() {
        return this.pattern;
    }

    public Pattern getPattern() {
        if (this.pattern == null) {
            return null;
        }
        return Pattern.compile(this.pattern.toString());
    }

    @Override
    void accept(Visitor visitor2) {
        visitor2.visitStringSchema(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StringSchema) {
            StringSchema that = (StringSchema)o;
            return that.canEqual(this) && this.requiresString == that.requiresString && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.formatValidator, that.formatValidator) && super.equals(that);
        }
        return false;
    }

    public FormatValidator getFormatValidator() {
        return this.formatValidator;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minLength, this.maxLength, this.pattern, this.requiresString, this.formatValidator);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StringSchema;
    }

    public boolean requireString() {
        return this.requiresString;
    }

    public static class Builder
    extends Schema.Builder<StringSchema> {
        private Integer minLength;
        private Integer maxLength;
        private Regexp pattern;
        private boolean requiresString = true;
        private FormatValidator formatValidator = FormatValidator.NONE;

        @Override
        public StringSchema build() {
            return new StringSchema(this);
        }

        public Builder formatValidator(FormatValidator formatValidator) {
            this.formatValidator = Objects.requireNonNull(formatValidator, "formatValidator cannot be null");
            return this;
        }

        public Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder pattern(String pattern) {
            return this.pattern(new JavaUtilRegexpFactory().createHandler(pattern));
        }

        public Builder pattern(Regexp pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder requiresString(boolean requiresString) {
            this.requiresString = requiresString;
            return this;
        }
    }
}

