/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.WriteShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class WriteShareGroupStateResponse
extends AbstractResponse {
    private final WriteShareGroupStateResponseData data;

    public WriteShareGroupStateResponse(WriteShareGroupStateResponseData data) {
        super(ApiKeys.WRITE_SHARE_GROUP_STATE);
        this.data = data;
    }

    @Override
    public WriteShareGroupStateResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.results().forEach(result2 -> result2.partitions().forEach(partitionResult -> this.updateErrorCounts(counts, Errors.forCode(partitionResult.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static WriteShareGroupStateResponse parse(ByteBuffer buffer, short version) {
        return new WriteShareGroupStateResponse(new WriteShareGroupStateResponseData(new ByteBufferAccessor(buffer), version));
    }

    public static WriteShareGroupStateResponseData toErrorResponseData(Uuid topicId, int partitionId, Errors error, String errorMessage) {
        WriteShareGroupStateResponseData responseData = new WriteShareGroupStateResponseData();
        responseData.setResults(Collections.singletonList(new WriteShareGroupStateResponseData.WriteStateResult().setTopicId(topicId).setPartitions(Collections.singletonList(new WriteShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage)))));
        return responseData;
    }

    public static WriteShareGroupStateResponseData.PartitionResult toErrorResponsePartitionResult(int partitionId, Errors error, String errorMessage) {
        return new WriteShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage);
    }

    public static WriteShareGroupStateResponseData.WriteStateResult toResponseWriteStateResult(Uuid topicId, List<WriteShareGroupStateResponseData.PartitionResult> partitionResults) {
        return new WriteShareGroupStateResponseData.WriteStateResult().setTopicId(topicId).setPartitions(partitionResults);
    }
}

