/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;

public class UpdateFeaturesRequest
extends AbstractRequest {
    private final UpdateFeaturesRequestData data;

    public UpdateFeaturesRequest(UpdateFeaturesRequestData data, short version) {
        super(ApiKeys.UPDATE_FEATURES, version);
        this.data = data;
    }

    public FeatureUpdateItem getFeature(String name2) {
        UpdateFeaturesRequestData.FeatureUpdateKey update = this.data.featureUpdates().find(name2);
        if (super.version() == 0) {
            if (update.allowDowngrade()) {
                return new FeatureUpdateItem(update.feature(), update.maxVersionLevel(), FeatureUpdate.UpgradeType.SAFE_DOWNGRADE);
            }
            return new FeatureUpdateItem(update.feature(), update.maxVersionLevel(), FeatureUpdate.UpgradeType.UPGRADE);
        }
        return new FeatureUpdateItem(update.feature(), update.maxVersionLevel(), FeatureUpdate.UpgradeType.fromCode(update.upgradeType()));
    }

    public Collection<FeatureUpdateItem> featureUpdates() {
        return this.data.featureUpdates().stream().map(update -> this.getFeature(update.feature())).collect(Collectors.toList());
    }

    @Override
    public UpdateFeaturesResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return UpdateFeaturesResponse.createWithErrors(ApiError.fromThrowable(e), Collections.emptyMap(), throttleTimeMs);
    }

    @Override
    public UpdateFeaturesRequestData data() {
        return this.data;
    }

    public static UpdateFeaturesRequest parse(ByteBuffer buffer, short version) {
        return new UpdateFeaturesRequest(new UpdateFeaturesRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<UpdateFeaturesRequest> {
        private final UpdateFeaturesRequestData data;

        public Builder(UpdateFeaturesRequestData data) {
            super(ApiKeys.UPDATE_FEATURES);
            this.data = data;
        }

        @Override
        public UpdateFeaturesRequest build(short version) {
            return new UpdateFeaturesRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }

    public static class FeatureUpdateItem {
        private final String featureName;
        private final short featureLevel;
        private final FeatureUpdate.UpgradeType upgradeType;

        public FeatureUpdateItem(String featureName, short featureLevel, FeatureUpdate.UpgradeType upgradeType) {
            this.featureName = featureName;
            this.featureLevel = featureLevel;
            this.upgradeType = upgradeType;
        }

        public String feature() {
            return this.featureName;
        }

        public short versionLevel() {
            return this.featureLevel;
        }

        public FeatureUpdate.UpgradeType upgradeType() {
            return this.upgradeType;
        }

        public boolean isDeleteRequest() {
            return this.featureLevel < 1 && !this.upgradeType.equals((Object)FeatureUpdate.UpgradeType.UPGRADE);
        }
    }
}

