/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class DeleteGroupsResponse
extends AbstractResponse {
    private final DeleteGroupsResponseData data;

    public DeleteGroupsResponse(DeleteGroupsResponseData data) {
        super(ApiKeys.DELETE_GROUPS);
        this.data = data;
    }

    @Override
    public DeleteGroupsResponseData data() {
        return this.data;
    }

    public Map<String, Errors> errors() {
        HashMap<String, Errors> errorMap = new HashMap<String, Errors>();
        for (DeleteGroupsResponseData.DeletableGroupResult result2 : this.data.results()) {
            errorMap.put(result2.groupId(), Errors.forCode(result2.errorCode()));
        }
        return errorMap;
    }

    public Errors get(String group) throws IllegalArgumentException {
        DeleteGroupsResponseData.DeletableGroupResult result2 = this.data.results().find(group);
        if (result2 == null) {
            throw new IllegalArgumentException("could not find group " + group + " in the delete group response");
        }
        return Errors.forCode(result2.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.results().forEach(result2 -> this.updateErrorCounts(counts, Errors.forCode(result2.errorCode())));
        return counts;
    }

    public static DeleteGroupsResponse parse(ByteBuffer buffer, short version) {
        return new DeleteGroupsResponse(new DeleteGroupsResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

