/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigTransformer;
import org.apache.kafka.common.config.ConfigTransformerResult;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConfig {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> used = ConcurrentHashMap.newKeySet();
    private final Map<String, ?> originals;
    private final Map<String, Object> values;
    private final ConfigDef definition;
    public static final String AUTOMATIC_CONFIG_PROVIDERS_PROPERTY = "org.apache.kafka.automatic.config.providers";
    public static final String CONFIG_PROVIDERS_CONFIG = "config.providers";
    private static final String CONFIG_PROVIDERS_PARAM = ".param.";

    public AbstractConfig(ConfigDef definition2, Map<?, ?> originals, Map<String, ?> configProviderProps, boolean doLog) {
        Map<String, Object> originalMap = Utils.castToStringObjectMap(originals);
        this.originals = this.resolveConfigVariables(configProviderProps, originalMap);
        this.values = definition2.parse(this.originals);
        Map<String, Object> configUpdates = this.postProcessParsedConfig(Collections.unmodifiableMap(this.values));
        this.values.putAll(configUpdates);
        definition2.parse(this.values);
        this.definition = definition2;
        if (doLog) {
            this.logAll();
        }
    }

    public AbstractConfig(ConfigDef definition2, Map<?, ?> originals) {
        this(definition2, originals, Collections.emptyMap(), true);
    }

    public AbstractConfig(ConfigDef definition2, Map<?, ?> originals, boolean doLog) {
        this(definition2, originals, Collections.emptyMap(), doLog);
    }

    protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
        return Collections.emptyMap();
    }

    protected Object get(String key) {
        if (!this.values.containsKey(key)) {
            throw new ConfigException(String.format("Unknown configuration '%s'", key));
        }
        this.used.add(key);
        return this.values.get(key);
    }

    public void ignore(String key) {
        this.used.add(key);
    }

    public Short getShort(String key) {
        return (Short)this.get(key);
    }

    public Integer getInt(String key) {
        return (Integer)this.get(key);
    }

    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public List<String> getList(String key) {
        return (List)this.get(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public String getString(String key) {
        String res = (String)this.get(key);
        return res == null ? res : res.trim();
    }

    public ConfigDef.Type typeOf(String key) {
        ConfigDef.ConfigKey configKey = this.definition.configKeys().get(key);
        if (configKey == null) {
            return null;
        }
        return configKey.type;
    }

    public String documentationOf(String key) {
        ConfigDef.ConfigKey configKey = this.definition.configKeys().get(key);
        if (configKey == null) {
            return null;
        }
        return configKey.documentation;
    }

    public Password getPassword(String key) {
        return (Password)this.get(key);
    }

    public Class<?> getClass(String key) {
        return (Class)this.get(key);
    }

    public Set<String> unused() {
        HashSet<String> keys2 = new HashSet<String>(this.originals.keySet());
        keys2.removeAll(this.used);
        return keys2;
    }

    public Map<String, Object> originals() {
        RecordingMap<Object> copy = new RecordingMap<Object>();
        copy.putAll(this.originals);
        return copy;
    }

    public Map<String, Object> originals(Map<String, Object> configOverrides) {
        RecordingMap<Object> copy = new RecordingMap<Object>();
        copy.putAll(this.originals);
        copy.putAll(configOverrides);
        return copy;
    }

    public Map<String, String> originalsStrings() {
        RecordingMap<String> copy = new RecordingMap<String>();
        for (Map.Entry<String, ?> entry : this.originals.entrySet()) {
            if (!(entry.getValue() instanceof String)) {
                throw new ClassCastException("Non-string value found in original settings for key " + entry.getKey() + ": " + (entry.getValue() == null ? null : entry.getValue().getClass().getName()));
            }
            copy.put(entry.getKey(), (String)entry.getValue());
        }
        return copy;
    }

    public Map<String, Object> originalsWithPrefix(String prefix) {
        return this.originalsWithPrefix(prefix, true);
    }

    public Map<String, Object> originalsWithPrefix(String prefix, boolean strip) {
        RecordingMap<Object> result2 = new RecordingMap<Object>(prefix, false);
        result2.putAll(Utils.entriesWithPrefix(this.originals, prefix, strip));
        return result2;
    }

    public Map<String, Object> valuesWithPrefixOverride(String prefix) {
        RecordingMap<Object> result2 = new RecordingMap<Object>(this.values(), prefix, true);
        for (Map.Entry<String, ?> entry : this.originals.entrySet()) {
            if (!entry.getKey().startsWith(prefix) || entry.getKey().length() <= prefix.length()) continue;
            String keyWithNoPrefix = entry.getKey().substring(prefix.length());
            ConfigDef.ConfigKey configKey = this.definition.configKeys().get(keyWithNoPrefix);
            if (configKey != null) {
                result2.put(keyWithNoPrefix, this.definition.parseValue(configKey, entry.getValue(), true));
                continue;
            }
            String keyWithNoSecondaryPrefix = keyWithNoPrefix.substring(keyWithNoPrefix.indexOf(46) + 1);
            configKey = this.definition.configKeys().get(keyWithNoSecondaryPrefix);
            if (configKey == null) continue;
            result2.put(keyWithNoPrefix, this.definition.parseValue(configKey, entry.getValue(), true));
        }
        return result2;
    }

    public Map<String, Object> valuesWithPrefixAllOrNothing(String prefix) {
        Map<String, Object> withPrefix = this.originalsWithPrefix(prefix, true);
        if (withPrefix.isEmpty()) {
            return new RecordingMap<Object>(this.values(), "", true);
        }
        RecordingMap<Object> result2 = new RecordingMap<Object>(prefix, true);
        for (Map.Entry<String, Object> entry : withPrefix.entrySet()) {
            ConfigDef.ConfigKey configKey = this.definition.configKeys().get(entry.getKey());
            if (configKey == null) continue;
            result2.put(entry.getKey(), this.definition.parseValue(configKey, entry.getValue(), true));
        }
        return result2;
    }

    public Map<String, ?> values() {
        return new RecordingMap<Object>(this.values);
    }

    public Map<String, ?> nonInternalValues() {
        RecordingMap nonInternalConfigs = new RecordingMap();
        this.values.forEach((key, value) -> {
            ConfigDef.ConfigKey configKey = this.definition.configKeys().get(key);
            if (configKey == null || !configKey.internalConfig) {
                nonInternalConfigs.put(key, value);
            }
        });
        return nonInternalConfigs;
    }

    private void logAll() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append(" values: ");
        b.append(Utils.NL);
        for (Map.Entry<String, Object> entry : new TreeMap<String, Object>(this.values).entrySet()) {
            b.append('\t');
            b.append(entry.getKey());
            b.append(" = ");
            b.append(entry.getValue());
            b.append(Utils.NL);
        }
        this.log.info(b.toString());
    }

    public void logUnused() {
        Set<String> unusedKeys = this.unused();
        if (!unusedKeys.isEmpty()) {
            this.log.info("These configurations '{}' were supplied but are not used yet.", (Object)unusedKeys);
        }
    }

    private <T> T getConfiguredInstance(Object klass, Class<T> t2, Map<String, Object> configPairs) {
        T o;
        if (klass == null) {
            return null;
        }
        if (klass instanceof String) {
            try {
                o = Utils.newInstance((String)klass, t2);
            }
            catch (ClassNotFoundException e) {
                throw new KafkaException("Class " + klass + " cannot be found", e);
            }
        } else if (klass instanceof Class) {
            o = Utils.newInstance((Class)klass);
        } else {
            throw new KafkaException("Unexpected element of type " + klass.getClass().getName() + ", expected String or Class");
        }
        try {
            if (!t2.isInstance(o)) {
                throw new KafkaException(klass + " is not an instance of " + t2.getName());
            }
            if (o instanceof Configurable) {
                ((Configurable)o).configure(configPairs);
            }
        }
        catch (Exception e) {
            AbstractConfig.maybeClose(o, "AutoCloseable object constructed and configured during failed call to getConfiguredInstance");
            throw e;
        }
        return t2.cast(o);
    }

    public <T> T getConfiguredInstance(String key, Class<T> t2) {
        return this.getConfiguredInstance(key, t2, Collections.emptyMap());
    }

    public <T> T getConfiguredInstance(String key, Class<T> t2, Map<String, Object> configOverrides) {
        Class<?> c = this.getClass(key);
        return this.getConfiguredInstance(c, t2, this.originals(configOverrides));
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t2) {
        return this.getConfiguredInstances(key, t2, Collections.emptyMap());
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t2, Map<String, Object> configOverrides) {
        return this.getConfiguredInstances(this.getList(key), t2, configOverrides);
    }

    public <T> List<T> getConfiguredInstances(List<String> classNames, Class<T> t2, Map<String, Object> configOverrides) {
        ArrayList<T> objects = new ArrayList<T>();
        if (classNames == null) {
            return objects;
        }
        Map<String, Object> configPairs = this.originals();
        configPairs.putAll(configOverrides);
        try {
            for (String klass : classNames) {
                T o = this.getConfiguredInstance((Object)klass, t2, configPairs);
                objects.add(t2.cast(o));
            }
        }
        catch (Exception e) {
            for (Object object : objects) {
                AbstractConfig.maybeClose(object, "AutoCloseable object constructed and configured during failed call to getConfiguredInstances");
            }
            throw e;
        }
        return objects;
    }

    private static void maybeClose(Object object, String name2) {
        if (object instanceof AutoCloseable) {
            Utils.closeQuietly((AutoCloseable)object, name2);
        }
    }

    private Map<String, String> extractPotentialVariables(Map<?, ?> configMap) {
        HashMap<String, String> configMapAsString = new HashMap<String, String>();
        for (Map.Entry<?, ?> entry : configMap.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            configMapAsString.put((String)entry.getKey(), (String)entry.getValue());
        }
        return configMapAsString;
    }

    private Map<String, ?> resolveConfigVariables(Map<String, ?> configProviderProps, Map<String, Object> originals) {
        ConfigTransformer configTransformer;
        ConfigTransformerResult result2;
        Predicate<String> classNameFilter;
        Map<String, Object> configProperties;
        Map<String, String> providerConfigString;
        HashMap<String, Object> resolvedOriginals = new HashMap<String, Object>();
        Map<String, String> indirectVariables = this.extractPotentialVariables(originals);
        resolvedOriginals.putAll(originals);
        if (configProviderProps == null || configProviderProps.isEmpty()) {
            providerConfigString = indirectVariables;
            configProperties = originals;
            classNameFilter = this.automaticConfigProvidersFilter();
        } else {
            providerConfigString = this.extractPotentialVariables(configProviderProps);
            configProperties = configProviderProps;
            classNameFilter = ignored -> true;
        }
        Map<String, ConfigProvider> providers = this.instantiateConfigProviders(providerConfigString, configProperties, classNameFilter);
        if (!providers.isEmpty() && !(result2 = (configTransformer = new ConfigTransformer(providers)).transform(indirectVariables)).data().isEmpty()) {
            resolvedOriginals.putAll(result2.data());
        }
        providers.values().forEach(x -> Utils.closeQuietly(x, "config provider"));
        return new ResolvingMap(resolvedOriginals, originals);
    }

    private Predicate<String> automaticConfigProvidersFilter() {
        String systemProperty = System.getProperty(AUTOMATIC_CONFIG_PROVIDERS_PROPERTY);
        if (systemProperty == null) {
            return ignored -> true;
        }
        return Arrays.stream(systemProperty.split(",")).map(String::trim).collect(Collectors.toSet())::contains;
    }

    private Map<String, Object> configProviderProperties(String configProviderPrefix, Map<String, ?> providerConfigProperties) {
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : providerConfigProperties.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(configProviderPrefix) || key.length() <= configProviderPrefix.length()) continue;
            result2.put(key.substring(configProviderPrefix.length()), entry.getValue());
        }
        return result2;
    }

    private Map<String, ConfigProvider> instantiateConfigProviders(Map<String, String> indirectConfigs, Map<String, ?> providerConfigProperties, Predicate<String> classNameFilter) {
        String configProviders = indirectConfigs.get(CONFIG_PROVIDERS_CONFIG);
        if (configProviders == null || configProviders.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> providerMap = new HashMap<String, String>();
        for (String provider : configProviders.split(",")) {
            String providerClass = AbstractConfig.providerClassProperty(provider);
            if (!indirectConfigs.containsKey(providerClass)) continue;
            String providerClassName = indirectConfigs.get(providerClass);
            if (classNameFilter.test(providerClassName)) {
                providerMap.put(provider, providerClassName);
                continue;
            }
            throw new ConfigException(providerClassName + " is not allowed. Update System property '" + AUTOMATIC_CONFIG_PROVIDERS_PROPERTY + "' to allow " + providerClassName);
        }
        HashMap<String, ConfigProvider> configProviderInstances = new HashMap<String, ConfigProvider>();
        for (Map.Entry entry : providerMap.entrySet()) {
            try {
                String prefix = "config.providers." + (String)entry.getKey() + CONFIG_PROVIDERS_PARAM;
                Map<String, Object> configProperties = this.configProviderProperties(prefix, providerConfigProperties);
                ConfigProvider provider = Utils.newInstance((String)entry.getValue(), ConfigProvider.class);
                provider.configure(configProperties);
                configProviderInstances.put((String)entry.getKey(), provider);
            }
            catch (ClassNotFoundException e) {
                this.log.error("Could not load config provider class " + (String)entry.getValue(), e);
                throw new ConfigException(AbstractConfig.providerClassProperty((String)entry.getKey()), entry.getValue(), "Could not load config provider class or one of its dependencies");
            }
        }
        return configProviderInstances;
    }

    private static String providerClassProperty(String providerName) {
        return String.format("%s.%s.class", CONFIG_PROVIDERS_CONFIG, providerName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConfig that = (AbstractConfig)o;
        return this.originals.equals(that.originals);
    }

    public int hashCode() {
        return this.originals.hashCode();
    }

    private static class ResolvingMap<V>
    extends HashMap<String, V> {
        private final Map<String, ?> originals;

        ResolvingMap(Map<String, ? extends V> resolved, Map<String, ?> originals) {
            super(resolved);
            this.originals = Collections.unmodifiableMap(originals);
        }

        @Override
        public V get(Object key) {
            if (key instanceof String && this.originals.containsKey(key)) {
                this.originals.get(key);
            }
            return super.get(key);
        }
    }

    private class RecordingMap<V>
    extends HashMap<String, V> {
        private final String prefix;
        private final boolean withIgnoreFallback;

        RecordingMap() {
            this("", false);
        }

        RecordingMap(String prefix, boolean withIgnoreFallback) {
            this.prefix = prefix;
            this.withIgnoreFallback = withIgnoreFallback;
        }

        RecordingMap(Map<String, ? extends V> m4) {
            this(m4, "", false);
        }

        RecordingMap(Map<String, ? extends V> m4, String prefix, boolean withIgnoreFallback) {
            super(m4);
            this.prefix = prefix;
            this.withIgnoreFallback = withIgnoreFallback;
        }

        @Override
        public V get(Object key) {
            if (key instanceof String) {
                String stringKey = (String)key;
                String keyWithPrefix = this.prefix.isEmpty() ? stringKey : this.prefix + stringKey;
                AbstractConfig.this.ignore(keyWithPrefix);
                if (this.withIgnoreFallback) {
                    AbstractConfig.this.ignore(stringKey);
                }
            }
            return super.get(key);
        }
    }
}

