/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum GroupType {
    UNKNOWN("Unknown"),
    CONSUMER("Consumer"),
    CLASSIC("Classic");

    private static final Map<String, GroupType> NAME_TO_ENUM;
    private final String name;

    private GroupType(String name2) {
        this.name = name2;
    }

    public static GroupType parse(String name2) {
        if (name2 == null) {
            return UNKNOWN;
        }
        GroupType type = NAME_TO_ENUM.get(name2.toLowerCase(Locale.ROOT));
        return type == null ? UNKNOWN : type;
    }

    public String toString() {
        return this.name;
    }

    static {
        NAME_TO_ENUM = Arrays.stream(GroupType.values()).collect(Collectors.toMap(type -> type.name.toLowerCase(Locale.ROOT), Function.identity()));
    }
}

